/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EventLoadController;
import com.denfop.api.energy.event.EventUnloadController;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.componets.EnergyNetDelegate;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerRemover;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiEnergyRemover;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.FakePlayerSpawner;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.world.WorldBaseGen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TileEnergyRemover
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyController {
    public final InvSlot slot;
    public Set<IEnergyConductor> conductorList = new HashSet<IEnergyConductor>();
    FakePlayerSpawner fakePlayer;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    int hashCodeSource;
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private boolean work;
    private long id;

    public TileEnergyRemover(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.energy_remover, pos, state);
        this.slot = new InvSlot(this, InvSlot.TypeItemSlot.OUTPUT, 16);
        this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 0.0, 14));
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.energy_remover;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            NeoForge.EVENT_BUS.post((Event)new EventLoadController(this, this.level));
            this.fakePlayer = new FakePlayerSpawner(this.getWorld());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().isClientSide) {
            NeoForge.EVENT_BUS.post((Event)new EventUnloadController(this, this.level));
        }
        super.onUnloaded();
    }

    public ContainerRemover getGuiContainer(Player entityPlayer) {
        return new ContainerRemover(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiEnergyRemover((ContainerRemover)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.getBoolean("work");
    }

    public void discover() {
        this.conductorList.clear();
        LinkedList<IEnergyTile> tileEntitiesToCheck = new LinkedList<IEnergyTile>();
        LinkedList<IEnergyConductor> reachedTileEntities = new LinkedList<IEnergyConductor>();
        EnergyNetDelegate tile = this.getComp(Energy.class).delegate;
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        while (!tileEntitiesToCheck.isEmpty()) {
            IEnergyTile currentTileEntity = (IEnergyTile)tileEntitiesToCheck.pop();
            List<InfoTile<IEnergyTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<IEnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((IEnergyTile)validReceiver.tileEntity).getIdNetwork() == id || !(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                ((IEnergyTile)validReceiver.tileEntity).setId(id);
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.push((IEnergyTile)validReceiver.tileEntity);
                reachedTileEntities.add((IEnergyConductor)validReceiver.tileEntity);
            }
        }
        this.conductorList.addAll(reachedTileEntities);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            for (IEnergyConductor conductor : this.conductorList) {
                TileEntityBlock tile = (TileEntityBlock)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor, this.level);
                List<ItemStack> drops = tile.getBlock().getDrops(this.level, tile.getPos(), tile.getBlockState(), null);
                if (!this.slot.add(drops.get(0))) continue;
                tile.onUnloaded();
                this.getWorld().removeBlock(tile.getPos(), false);
            }
            this.work = false;
            this.discover();
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.level.isClientSide) {
            return;
        }
        if (i == 0.0) {
            this.discover();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.discover();
        }
    }

    @Override
    public void unload() {
        this.conductorList.clear();
    }
}

