/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multimechanism.simple;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.tiles.mechanism.multimechanism.IFarmer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TileFermer
extends TileMultiMachine
implements IFarmer {
    private final InvSlot fertilizerSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.getItem() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    private final AirPollutionComponent pollutionAir;
    private final SoilPollutionComponent pollutionSoil;
    int col = 0;

    public TileFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.Fermer.usagePerTick, EnumMultiMachine.Fermer.lenghtOperation, BlockMoreMachine3.farmer, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.15));
    }

    public static void addrecipe(ItemStack input, Item output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, new ItemStack((ItemLike)output))));
    }

    public static void addrecipe(ItemStack input, Item output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, new ItemStack((ItemLike)output, n))));
    }

    public static void addrecipe(Item input, ItemStack output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output.getItem(), n))));
    }

    public static void addrecipe(Item input, Item output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output))));
    }

    public static void addrecipe(ItemStack input, ItemStack output) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addrecipe(ItemStack input, ItemStack output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        output = output.copy();
        output.setCount(n);
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(input)), new RecipeOutput(null, output)));
    }

    public static void addrecipe(Item input, Item output, int n) {
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("farmer", new BaseMachineRecipe(new Input(input1.getInput(new ItemStack((ItemLike)input))), new RecipeOutput(null, new ItemStack((ItemLike)output, n))));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public InvSlot getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).getCount() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.isEmpty() && this.fertilizerSlot.get(0).getCount() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).shrink(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockMoreMachine3.farmer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base3.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        TileFermer.addrecipe(Items.WHEAT_SEEDS, Items.WHEAT, 2);
        TileFermer.addrecipe(Items.WHEAT, Items.WHEAT_SEEDS, 1);
        TileFermer.addrecipe(new ItemStack((ItemLike)IUItem.rubberSapling.getItem()), new ItemStack((ItemLike)IUItem.rubWood.getItem(0)), 1);
        TileFermer.addrecipe(new ItemStack((ItemLike)IUItem.rubWood.getItem(0)), new ItemStack((ItemLike)IUItem.rawLatex.getItem(), 2), 2);
        TileFermer.addrecipe(IUItem.rawLatex.getItem(), new ItemStack((ItemLike)IUItem.rubberSapling.getItem()), 1);
        TileFermer.addrecipe(Items.CARROT, Items.CARROT, 2);
        TileFermer.addrecipe(Items.POTATO, Items.POTATO, 2);
        TileFermer.addrecipe(Blocks.PUMPKIN.asItem(), Items.PUMPKIN_SEEDS, 1);
        TileFermer.addrecipe(Items.PUMPKIN_SEEDS, Blocks.PUMPKIN.asItem(), 2);
        TileFermer.addrecipe(Items.MELON_SEEDS, Items.MELON, 2);
        TileFermer.addrecipe(Items.MELON, Items.MELON_SEEDS, 1);
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.OAK_SAPLING, 1), new ItemStack((ItemLike)Blocks.OAK_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.BIRCH_SAPLING, 1), new ItemStack((ItemLike)Blocks.BIRCH_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.ACACIA_SAPLING, 1), new ItemStack((ItemLike)Blocks.ACACIA_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.JUNGLE_SAPLING, 1), new ItemStack((ItemLike)Blocks.JUNGLE_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.DARK_OAK_SAPLING, 1), new ItemStack((ItemLike)Blocks.DARK_OAK_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.SPRUCE_SAPLING, 1), new ItemStack((ItemLike)Blocks.SPRUCE_LOG, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.OAK_LOG, 1), new ItemStack((ItemLike)Blocks.OAK_SAPLING, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.BIRCH_LOG, 1), new ItemStack((ItemLike)Blocks.BIRCH_SAPLING, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.ACACIA_LOG, 1), new ItemStack((ItemLike)Blocks.ACACIA_SAPLING, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.JUNGLE_LOG, 1), new ItemStack((ItemLike)Blocks.JUNGLE_SAPLING, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.DARK_OAK_LOG, 1), new ItemStack((ItemLike)Blocks.DARK_OAK_SAPLING, 2));
        TileFermer.addrecipe(new ItemStack((ItemLike)Blocks.SPRUCE_LOG, 1), new ItemStack((ItemLike)Blocks.SPRUCE_SAPLING, 2));
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.Fermer;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockFermer.name");
    }

    public String getStartSoundFile() {
        return "Machines/Fermer.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

