/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee.genetics;

import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticsManager;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import java.util.ArrayList;
import java.util.List;

public enum GeneticTraits {
    SOIL_I(EnumGenetic.SOIL, LevelPollution.MEDIUM, null),
    SOIL_II(EnumGenetic.SOIL, LevelPollution.HIGH, SOIL_I),
    SOIL_III(EnumGenetic.SOIL, LevelPollution.VERY_HIGH, SOIL_II),
    FOOD_I(EnumGenetic.FOOD, 1.1, null),
    FOOD_II(EnumGenetic.FOOD, 1.25, FOOD_I),
    FOOD_III(EnumGenetic.FOOD, 1.5, FOOD_II),
    BIOME(EnumGenetic.COEF_BIOME, true, null),
    JELLY_I(EnumGenetic.JELLY, 1.1, null),
    JELLY_II(EnumGenetic.JELLY, 1.25, JELLY_I),
    JELLY_III(EnumGenetic.JELLY, 1.5, JELLY_II),
    WEATHER_I(EnumGenetic.WEATHER, 1, null),
    WEATHER_II(EnumGenetic.WEATHER, 2, WEATHER_I),
    PRODUCT_I(EnumGenetic.PRODUCT, 1.075, null),
    PRODUCT_II(EnumGenetic.PRODUCT, 1.15, PRODUCT_I),
    PRODUCT_III(EnumGenetic.PRODUCT, 1.225, PRODUCT_II),
    BIRTH_I(EnumGenetic.BIRTH, 1.2, null),
    BIRTH_II(EnumGenetic.BIRTH, 1.4, BIRTH_I),
    BIRTH_III(EnumGenetic.BIRTH, 1.6, BIRTH_II),
    HARDENING_I(EnumGenetic.HARDENING, 0.8, null),
    HARDENING_II(EnumGenetic.HARDENING, 0.6, HARDENING_I),
    HARDENING_III(EnumGenetic.HARDENING, 0.4, HARDENING_II),
    POPULATION_I(EnumGenetic.POPULATION, 1.1, null),
    POPULATION_II(EnumGenetic.POPULATION, 1.2, POPULATION_I),
    POPULATION_III(EnumGenetic.POPULATION, 1.4, POPULATION_II),
    SWARM_I(EnumGenetic.SWARM, 1.15, null),
    SWARM_II(EnumGenetic.SWARM, 1.3, SWARM_I),
    SWARM_III(EnumGenetic.SWARM, 1.45, SWARM_II),
    MORTALITY_I(EnumGenetic.MORTALITY_RATE, 0.9, null),
    MORTALITY_II(EnumGenetic.MORTALITY_RATE, 0.8, MORTALITY_I),
    MORTALITY_III(EnumGenetic.MORTALITY_RATE, 0.7, MORTALITY_II),
    PEST_I(EnumGenetic.PEST, 1.1, null),
    PEST_II(EnumGenetic.PEST, 1.2, PEST_I),
    PEST_III(EnumGenetic.PEST, 1.4, PEST_II),
    RADIUS_I(EnumGenetic.RADIUS, 1.5, null),
    RADIUS_II(EnumGenetic.RADIUS, 2.0, RADIUS_I),
    RADIUS_III(EnumGenetic.RADIUS, 2.5, RADIUS_II),
    SUN(EnumGenetic.SUN, true, null),
    NIGHT(EnumGenetic.NIGHT, true, null),
    AIR_I(EnumGenetic.AIR, LevelPollution.MEDIUM, null),
    AIR_II(EnumGenetic.AIR, LevelPollution.HIGH, AIR_I),
    AIR_III(EnumGenetic.AIR, LevelPollution.VERY_HIGH, AIR_II),
    RADIATION_I(EnumGenetic.RADIATION, EnumLevelRadiation.MEDIUM, null),
    RADIATION_II(EnumGenetic.RADIATION, EnumLevelRadiation.HIGH, RADIATION_I),
    RADIATION_III(EnumGenetic.RADIATION, EnumLevelRadiation.VERY_HIGH, RADIATION_II),
    GENOME_RESISTANCE_I(EnumGenetic.GENOME_RESISTANCE, 25, null),
    GENOME_RESISTANCE_II(EnumGenetic.GENOME_RESISTANCE, 50, GENOME_RESISTANCE_I),
    GENOME_RESISTANCE_III(EnumGenetic.GENOME_RESISTANCE, 100, GENOME_RESISTANCE_II),
    GENOME_ADAPTIVE_I(EnumGenetic.GENOME_ADAPTIVE, 20, null),
    GENOME_ADAPTIVE_II(EnumGenetic.GENOME_ADAPTIVE, 40, GENOME_ADAPTIVE_I),
    GENOME_ADAPTIVE_III(EnumGenetic.GENOME_ADAPTIVE, 60, GENOME_ADAPTIVE_II);

    private final EnumGenetic genetic;
    private final Object value;
    private final GeneticTraits prev;

    private <T> GeneticTraits(EnumGenetic genetic, T value, GeneticTraits prev) {
        List<GeneticTraits> geneticTraits;
        this.genetic = genetic;
        this.value = value;
        this.prev = prev;
        if (prev != null) {
            GeneticsManager.geneticTraitsMap.put(prev, this);
        }
        if ((geneticTraits = GeneticsManager.enumGeneticListMap.get((Object)genetic)) == null) {
            geneticTraits = new ArrayList<GeneticTraits>();
            geneticTraits.add(this);
            GeneticsManager.enumGeneticListMap.put(genetic, geneticTraits);
        } else {
            geneticTraits.add(this);
        }
    }

    public static void init() {
        for (GeneticTraits genetic : GeneticTraits.values()) {
            List<GeneticTraits> geneticTraits;
            if (genetic.prev != null) {
                GeneticsManager.geneticTraitsMap.put(genetic.prev, genetic);
            }
            if ((geneticTraits = GeneticsManager.enumGeneticListMap.get((Object)genetic.genetic)) == null) {
                geneticTraits = new ArrayList<GeneticTraits>();
                geneticTraits.add(genetic);
                GeneticsManager.enumGeneticListMap.put(genetic.genetic, geneticTraits);
                continue;
            }
            geneticTraits.add(genetic);
        }
    }

    public GeneticTraits getPrev() {
        return this.prev;
    }

    public <T> T getValue(Class<T> type) {
        return type.cast(this.value);
    }

    public EnumGenetic getGenetic() {
        return this.genetic;
    }
}

