/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.api.gui.GuiPageButtonList;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.gui.GuiCore;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GuiVerticalSlider
extends AbstractWidget {
    private static final ResourceLocation TEXTURES = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/slider.png");
    private final String name;
    private final int def;
    private final FormatHelper formatHelper;
    private final GuiPageButtonList.GuiResponder responder;
    private final int id;
    private String displayString1;
    private int min;
    private int max;
    private int sizeRender;
    private float sliderPosition = 1.0f;
    private boolean isMouseDown;

    public GuiVerticalSlider(GuiPageButtonList.GuiResponder p_i45541_1_, int p_i45541_2_, int x, int y, String name, int min, int max, int def, FormatHelper p_i45541_9_, int height) {
        super(x, y, 1, height, (Component)Component.literal((String)""));
        this.name = name;
        this.min = min;
        this.id = p_i45541_2_;
        this.max = max;
        this.def = def;
        this.sliderPosition = (float)(def - min) / (float)(max - min);
        this.updateRenderSize();
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    private String getDisplayString() {
        return this.formatHelper == null ? I18n.get((String)this.name, (Object[])new Object[0]) + ": " + this.getSliderValue() : this.formatHelper.getText(this.id, I18n.get((String)this.name, (Object[])new Object[0]), this.getSliderValue());
    }

    private void updateRenderSize() {
        this.sizeRender = Math.max(1, (int)Math.floor((double)this.height * ((double)(this.max - this.min) / ((double)this.max + 1.0))));
    }

    public float getSliderValue() {
        return (float)this.min + (float)(this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float value) {
        this.sliderPosition = (value - (float)this.min) / (float)(this.max - this.min);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
    }

    public void renderWidget(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        GuiCore.bindTexture(TEXTURES);
        stack.blit(TEXTURES, this.getX(), this.getY() - 1, 255, 0, 1, this.height - 2);
        stack.blit(TEXTURES, this.getX() - 1, this.getY() - 2, 3, 0, 4, 1);
        stack.blit(TEXTURES, this.getX() - 1, this.getY() + this.height - 4, 3, 0, 4, 1);
        stack.blit(TEXTURES, this.getX() - 1, this.getY() + this.height / 2 - 3, 3, 0, 4, 1);
        for (int y = this.getY() + this.height / 4 - 2; y < this.getY() + this.height - 1 - 2; y += this.height / 4) {
            stack.blit(TEXTURES, this.getX() - 1, y, 4, 3, 3, 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.blit(TEXTURES, this.getX() - 2, this.getY() + (int)(this.sliderPosition * (float)(this.height - 3)) - 2, 3, 7, 5, 3);
        int j = 0xE0E0E0;
        if (this.packedFGColor != 0) {
            j = this.packedFGColor;
        } else if (!this.active) {
            j = 0xA0A0A0;
        } else if (this.isHovered) {
            j = 0xFFFFA0;
        }
        stack.drawCenteredString(Minecraft.getInstance().font, this.getDisplayString(), this.getX() + (this.width - 8) / 2 + 4 + Minecraft.getInstance().font.width(this.displayString1) - 5, this.getY() + this.height / 2 - 7, j);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.isMouseDown = true;
            this.updateSliderPosition(mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isMouseDown = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isMouseDown) {
            this.updateSliderPosition(mouseY);
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, this.getDisplayString());
    }

    private void updateSliderPosition(double mouseY) {
        this.sliderPosition = (float)(mouseY - (double)(this.getY() + 4)) / (float)(this.height - 8);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
        this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
    }

    public void setMin(int min) {
        this.min = min;
        this.setMax(this.max);
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.getX() - 4 && mouseX < this.getX() + 4 && mouseY >= this.getY() && mouseY < this.getY() + this.height;
    }

    public boolean handleMouseWheel(ScrollDirection direction, int mouseX, int mouseY) {
        if (this.visible && this.isMouseOver(mouseX, mouseY)) {
            float step = 1.0f / (float)(this.max - this.min);
            this.sliderPosition += direction == ScrollDirection.down ? step : -step;
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString1 = this.getDisplayString();
            this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
            return true;
        }
        return false;
    }

    public void setMax(int p_i45541_7_) {
        if (this.max != p_i45541_7_) {
            this.max = p_i45541_7_;
            this.sizeRender = this.max == 0 ? this.height : (int)((double)(this.height - 8) / ((double)(this.max - this.min) * 1.0));
            if (this.sizeRender < 1) {
                this.sizeRender = 1;
            }
            this.sliderPosition = (float)((double)this.def * ((double)(this.height - 8) / ((double)(this.max - this.min) * 1.0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

