/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IBuildingHouse;
import com.denfop.api.space.colonies.enums.EnumHouses;
import com.denfop.api.space.colonies.enums.EnumHousesLevel;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.world.WorldBaseGen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class ColonyHouse
extends Building
implements IBuildingHouse {
    private final EnumHouses houses;
    private byte freeWorkers;
    private byte workers;
    private byte timeToDecrease;
    private byte timeToIncrease;
    private byte peoples;

    public ColonyHouse(EnumHouses houses, IColony colonie, boolean simulate) {
        super(colonie);
        this.houses = houses;
        this.peoples = (byte)(houses.getMax() / 2 + WorldBaseGen.random.nextInt(houses.getMax() / 2 + 1));
        this.timeToDecrease = (byte)3;
        this.timeToIncrease = (byte)20;
        this.freeWorkers = this.peoples;
        this.workers = 0;
        if (!simulate) {
            this.getColony().addBuilding(this);
        }
    }

    public ColonyHouse(CompoundTag tag, IColony colonie) {
        super(colonie);
        byte id = tag.getByte("id");
        this.houses = EnumHouses.getID(id);
        this.peoples = tag.getByte("people");
        this.freeWorkers = tag.getByte("freeWorkers");
        this.workers = tag.getByte("workers");
        this.timeToDecrease = tag.getByte("timeToDecrease");
        this.timeToIncrease = tag.getByte("timeToIncrease");
        this.getColony().addBuilding(this);
    }

    public ColonyHouse(CustomPacketBuffer packetBuffer, Colony colonie) {
        super(colonie);
        byte id = packetBuffer.readByte();
        this.houses = EnumHouses.getID(id);
        this.peoples = packetBuffer.readByte();
        this.freeWorkers = packetBuffer.readByte();
        this.workers = packetBuffer.readByte();
        this.timeToDecrease = packetBuffer.readByte();
        this.timeToIncrease = packetBuffer.readByte();
        this.getColony().addBuilding(this);
    }

    @Override
    public EnumHouses getHouses() {
        return this.houses;
    }

    @Override
    public EnumHousesLevel getLevel() {
        return this.houses.getLevel();
    }

    @Override
    public int getPeople() {
        return this.peoples;
    }

    @Override
    public int getEnergy() {
        return this.houses.getEnergy();
    }

    @Override
    public int getMaxPeople() {
        return this.houses.getMax();
    }

    @Override
    public void addPeople(int peoples) {
        if (peoples > 0) {
            int prev = this.peoples;
            this.peoples = (byte)(this.peoples + (byte)peoples);
            if (this.peoples > this.getMaxPeople()) {
                this.peoples = (byte)this.getMaxPeople();
            }
            prev = this.peoples - prev;
            this.freeWorkers = (byte)(this.freeWorkers + (byte)prev);
            this.getColony().addFreeWorkers(prev);
        } else {
            this.peoples = (byte)(this.peoples - (byte)peoples);
            for (peoples = Math.abs(peoples); peoples > 0; --peoples) {
                int number = WorldBaseGen.random.nextInt(this.freeWorkers + this.workers);
                if (number < this.freeWorkers) {
                    this.freeWorkers = (byte)(this.freeWorkers - 1);
                    this.getColony().addFreeWorkers(-1);
                    continue;
                }
                this.workers = (byte)(this.workers - 1);
            }
        }
    }

    @Override
    public int getWorkers() {
        return this.workers;
    }

    @Override
    public int getFreeWorkers() {
        return this.freeWorkers;
    }

    @Override
    public void removeFreeWorkers(int workers) {
        this.freeWorkers = (byte)(this.freeWorkers - (byte)workers);
        this.workers = (byte)(this.workers + (byte)workers);
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.houses.ordinal());
        customPacketBuffer.writeByte(this.peoples);
        customPacketBuffer.writeByte(this.freeWorkers);
        customPacketBuffer.writeByte(this.workers);
        customPacketBuffer.writeByte(this.timeToDecrease);
        customPacketBuffer.writeByte(this.timeToIncrease);
        return customPacketBuffer;
    }

    @Override
    public CompoundTag writeTag(CompoundTag tag, HolderLookup.Provider p_323640_) {
        super.writeTag(tag, p_323640_);
        tag.putByte("id", (byte)this.houses.ordinal());
        tag.putByte("people", this.peoples);
        tag.putByte("workers", this.workers);
        tag.putByte("freeWorkers", this.freeWorkers);
        tag.putByte("timeToDecrease", this.timeToDecrease);
        tag.putByte("timeToDecrease", this.timeToIncrease);
        return tag;
    }

    @Override
    public int getMinLevelColony() {
        return this.houses.getLevel().getLevel();
    }

    @Override
    public void work() {
        boolean problem = false;
        if (this.getColony().getEnergy() >= this.getEnergy()) {
            this.getColony().useEnergy(this.getEnergy());
        } else {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
            problem = true;
        }
        if (this.houses.getConsumeOxygen() * (double)this.peoples > (double)this.getColony().getOxygen()) {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.OXYGEN)) {
                this.getColony().getProblems().add(EnumProblems.OXYGEN);
            }
            this.getColony().useOxygen(this.getColony().getOxygen());
            problem = true;
        } else {
            this.getColony().useOxygen((int)(this.houses.getConsumeOxygen() * (double)this.peoples));
        }
        if (this.peoples > this.getColony().getFood()) {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.FOOD)) {
                this.getColony().getProblems().add(EnumProblems.FOOD);
            }
            this.getColony().useFood(this.getColony().getFood());
            problem = true;
        } else {
            this.getColony().useFood(this.peoples);
        }
        if (!problem) {
            this.timeToDecrease = (byte)3;
            if (this.getPeople() < this.getMaxPeople() && this.getColony().canUseFood(this.houses) && this.getColony().canUseOxygen(this.houses)) {
                if (this.timeToIncrease == 0) {
                    this.addPeople(1);
                    this.timeToIncrease = (byte)20;
                } else {
                    this.timeToIncrease = (byte)(this.timeToIncrease - 1);
                }
            }
        } else {
            this.timeToDecrease = (byte)(this.timeToDecrease - 1);
            this.timeToIncrease = (byte)20;
            if (this.timeToDecrease == 0 && this.getPeople() > 0) {
                int temp = this.getWorkers();
                this.addPeople(-1);
                int temp1 = this.getWorkers();
                this.getColony().removeWorkers(temp - temp1);
                this.timeToDecrease = (byte)3;
            }
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.HOUSES;
    }

    @Override
    public byte getId() {
        return 0;
    }
}

