/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.tesseract;

import com.denfop.api.energy.IDual;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.ChannelHandler;
import com.denfop.api.tesseract.ITesseract;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.componets.Energy;
import com.denfop.invslot.InvSlot;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TesseractLocalSystem {
    Map<BlockPos, ITesseract> tesseractMap = new HashMap<BlockPos, ITesseract>();
    Map<Integer, ChannelHandler> inputChannels = new HashMap<Integer, ChannelHandler>();
    Map<Integer, ChannelHandler> outputChannels = new HashMap<Integer, ChannelHandler>();
    List<Channel> publicChannelList = new LinkedList<Channel>();

    public void add(ITesseract tesseract) {
        if (!this.tesseractMap.containsKey(tesseract.getPos())) {
            this.tesseractMap.put(tesseract.getPos(), tesseract);
            for (Channel channel : tesseract.getChannels()) {
                this.addChannel(channel);
            }
        }
    }

    public void removeChannel(Channel channel) {
        if (channel.getMode() == TypeMode.INOUT) {
            ChannelHandler channelHandler = this.inputChannels.get(channel.getChannel());
            channelHandler.removeChannel(channel);
            ChannelHandler channelHandler1 = this.outputChannels.get(channel.getChannel());
            channelHandler1.removeChannel(channel);
        } else if (channel.getMode() == TypeMode.INPUT) {
            ChannelHandler channelHandler = this.inputChannels.get(channel.getChannel());
            channelHandler.removeChannel(channel);
        } else if (channel.getMode() == TypeMode.OUTPUT) {
            ChannelHandler channelHandler = this.outputChannels.get(channel.getChannel());
            channelHandler.removeChannel(channel);
        }
        if (!channel.isPrivate()) {
            this.publicChannelList.remove(channel);
        }
    }

    public void addChannel(Channel channel) {
        if (channel.getMode() == TypeMode.INOUT) {
            ChannelHandler channelHandler = this.inputChannels.get(channel.getChannel());
            if (channelHandler == null) {
                channelHandler = new ChannelHandler();
                channelHandler.addChannel(channel);
                this.inputChannels.put(channel.getChannel(), channelHandler);
            } else {
                channelHandler.addChannel(channel);
            }
            ChannelHandler channelHandler1 = this.outputChannels.get(channel.getChannel());
            if (channelHandler1 == null) {
                channelHandler1 = new ChannelHandler();
                channelHandler1.addChannel(channel);
                this.outputChannels.put(channel.getChannel(), channelHandler1);
            } else {
                channelHandler1.addChannel(channel);
            }
        } else if (channel.getMode() == TypeMode.INPUT) {
            ChannelHandler channelHandler = this.inputChannels.get(channel.getChannel());
            if (channelHandler == null) {
                channelHandler = new ChannelHandler();
                channelHandler.addChannel(channel);
                this.inputChannels.put(channel.getChannel(), channelHandler);
            } else {
                channelHandler.addChannel(channel);
            }
        } else if (channel.getMode() == TypeMode.OUTPUT) {
            ChannelHandler channelHandler = this.outputChannels.get(channel.getChannel());
            if (channelHandler == null) {
                channelHandler = new ChannelHandler();
                channelHandler.addChannel(channel);
                this.outputChannels.put(channel.getChannel(), channelHandler);
            } else {
                channelHandler.addChannel(channel);
            }
        }
        if (!channel.isPrivate()) {
            this.publicChannelList.add(channel);
        }
    }

    public void remove(ITesseract tesseract) {
        ITesseract tesseract1 = this.tesseractMap.remove(tesseract.getPos());
        if (tesseract1 != null) {
            for (Channel channel : tesseract1.getChannels()) {
                this.removeChannel(channel);
            }
        }
    }

    public void onTick() {
        for (Map.Entry<Integer, ChannelHandler> entry : this.outputChannels.entrySet()) {
            Object two;
            Object one;
            int channel = entry.getKey();
            ChannelHandler handlerOutput = entry.getValue();
            ChannelHandler handlerInput = this.inputChannels.get(channel);
            if (handlerInput == null) break;
            block1: for (Channel channel1 : handlerOutput.getListEnergy()) {
                if (!channel1.isActive()) continue;
                for (Channel channel2 : handlerInput.getListEnergy()) {
                    double sent;
                    double demanded;
                    double energy;
                    if (!channel2.isActive() || channel1 == channel2) continue;
                    if (channel1.isPrivate()) {
                        if (!channel2.isPrivate() || !channel1.getTesseract().getPlayer().equals(channel2.getTesseract().getPlayer())) continue;
                        one = channel1.getTesseract().getEnergy();
                        if (((Energy)one).getEnergy() == 0.0) continue block1;
                        two = channel2.getTesseract().getEnergy();
                        energy = ((IDual)((Energy)one).getDelegate()).canExtractEnergy();
                        demanded = ((IDual)((Energy)two).getDelegate()).getDemandedEnergy();
                        sent = Math.min(energy, demanded);
                        ((IDual)((Energy)one).getDelegate()).extractEnergy(sent);
                        ((IDual)((Energy)two).getDelegate()).receiveEnergy(sent);
                        continue;
                    }
                    if (channel2.isPrivate()) continue;
                    one = channel1.getTesseract().getEnergy();
                    if (((Energy)one).getEnergy() == 0.0) continue block1;
                    two = channel2.getTesseract().getEnergy();
                    energy = ((IDual)((Energy)one).getDelegate()).canExtractEnergy();
                    demanded = ((IDual)((Energy)two).getDelegate()).getDemandedEnergy();
                    sent = Math.min(energy, demanded);
                    ((IDual)((Energy)one).getDelegate()).extractEnergy(sent);
                    ((IDual)((Energy)two).getDelegate()).receiveEnergy(sent);
                }
            }
            block3: for (Channel channel1 : handlerOutput.getListFluid()) {
                if (!channel1.isActive()) continue;
                for (Channel channel2 : handlerInput.getListFluid()) {
                    int sent;
                    int canDrain;
                    int canFill;
                    FluidStack stack;
                    if (!channel2.isActive() || channel1 == channel2) continue;
                    if (channel1.isPrivate()) {
                        if (!channel2.isPrivate() || !channel1.getTesseract().getPlayer().equals(channel2.getTesseract().getPlayer())) continue;
                        one = channel1.getTesseract().getTank();
                        two = channel2.getTesseract().getTank();
                        if (one.getFluidAmount() == 0) continue block3;
                        stack = one.getFluid();
                        if (two.getFluidAmount() == 0) {
                            two.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                            one.drain(stack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                            continue;
                        }
                        if (!FluidStack.isSameFluid((FluidStack)two.getFluid(), (FluidStack)stack)) continue;
                        canFill = two.getCapacity() - two.getFluidAmount();
                        canDrain = stack.getAmount();
                        sent = Math.min(canFill, canDrain);
                        two.fill(new FluidStack(two.getFluid().getFluid(), sent), IFluidHandler.FluidAction.EXECUTE);
                        one.drain(sent, IFluidHandler.FluidAction.EXECUTE);
                        continue;
                    }
                    if (channel2.isPrivate()) continue;
                    one = channel1.getTesseract().getTank();
                    two = channel2.getTesseract().getTank();
                    if (one.getFluidAmount() == 0) continue block3;
                    stack = one.getFluid();
                    if (two.getFluidAmount() == 0) {
                        two.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                        one.drain(stack.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        continue;
                    }
                    if (!FluidStack.isSameFluid((FluidStack)two.getFluid(), (FluidStack)stack)) continue;
                    canFill = two.getCapacity() - two.getFluidAmount();
                    canDrain = stack.getAmount();
                    sent = Math.min(canFill, canDrain);
                    two.fill(new FluidStack(two.getFluid().getFluid(), sent), IFluidHandler.FluidAction.EXECUTE);
                    one.drain(sent, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            block5: for (Channel channel1 : handlerOutput.getListItem()) {
                if (!channel1.isActive()) continue;
                for (Channel channel2 : handlerInput.getListItem()) {
                    int countFill;
                    ItemStack stack;
                    int i;
                    if (!channel2.isActive() || channel1 == channel2) continue;
                    if (channel1.isPrivate()) {
                        if (!channel2.isPrivate() || !channel1.getTesseract().getPlayer().equals(channel2.getTesseract().getPlayer())) continue;
                        one = channel1.getTesseract().getSlotItem();
                        two = channel2.getTesseract().getSlotItem();
                        if (((InvSlot)one).isEmpty()) continue block5;
                        for (i = 0; i < ((InvSlot)one).size(); ++i) {
                            stack = ((InvSlot)one).get(i);
                            if (stack.isEmpty()) continue;
                            countFill = ((InvSlot)two).addExperimental(stack);
                            if (countFill == 0) {
                                ((InvSlot)one).set(i, ItemStack.EMPTY);
                                continue;
                            }
                            stack.setCount(countFill);
                        }
                        continue;
                    }
                    if (channel2.isPrivate()) continue;
                    one = channel1.getTesseract().getSlotItem();
                    two = channel2.getTesseract().getSlotItem();
                    if (((InvSlot)one).isEmpty()) continue block5;
                    for (i = 0; i < ((InvSlot)one).size(); ++i) {
                        stack = ((InvSlot)one).get(i);
                        if (stack.isEmpty()) continue;
                        countFill = ((InvSlot)two).addExperimental(stack);
                        if (countFill == 0) {
                            ((InvSlot)one).set(i, ItemStack.EMPTY);
                            continue;
                        }
                        stack.setCount(countFill);
                    }
                }
            }
        }
    }

    public void onUnload() {
        this.tesseractMap.clear();
        this.inputChannels.clear();
        this.outputChannels.clear();
        this.publicChannelList.clear();
    }

    public List<Channel> getPublicChannels() {
        return this.publicChannelList;
    }
}

