/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemWindRotor;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;

public class InvSlotWindRotor
extends InvSlot
implements ITypeSlot {
    private final TileWindGenerator windGenerator;

    public InvSlotWindRotor(TileWindGenerator windGenerator) {
        super(windGenerator, InvSlot.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(1);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.ROTOR;
    }

    public int damage(int amount, double chance) {
        int damageApplied = 0;
        if (chance > 0.0 && this.windGenerator.getWorld().random.nextInt(101) > (int)(chance * 100.0)) {
            return 0;
        }
        ItemStack stack = this.get(0);
        ItemWindRotor rotor = (ItemWindRotor)stack.getItem();
        if (!ModUtils.isEmpty(stack)) {
            DamageHandler.damage(stack, amount, null);
            if ((double)DamageHandler.getDamage(stack) >= (double)DamageHandler.getMaxDamage(stack) * 0.25) {
                this.windGenerator.need_repair = true;
            }
        }
        return damageApplied;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return stack.getItem() instanceof ItemWindRotor && ((IWindRotor)stack.getItem()).getLevel() >= this.windGenerator.getLevelGenerator().getMin() && ((IWindRotor)stack.getItem()).getLevel() <= this.windGenerator.getLevelGenerator().getMax();
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.windGenerator.change();
        if (!content.isEmpty()) {
            this.windGenerator.energy.setSourceTier(this.windGenerator.getRotor().getSourceTier());
        } else {
            this.windGenerator.energy.setSourceTier(1);
        }
        return content;
    }
}

