/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.IUItem;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import oshi.util.tuples.Pair;

public class BlockBasaltHeavyOre<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public BlockBasaltHeavyOre(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).destroyTime(1.0f).explosionResistance(5.0f).sound(SoundType.STONE).requiresCorrectToolForDrops(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)IUItem.heavyore.getItem(this.getMetaFromState(state)));
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)IUItem.heavyore.getItem(this.getMetaFromState(state))));
        drops.add(new ItemStack((ItemLike)IUItem.basalts.getItem(0)));
        return drops;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        int levelEnchant = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Level)level).registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
        return levelEnchant == 0;
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.createBlockStateDefinition(p_49915_);
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.stateDefinition.any();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        Magnetite(0),
        Calaverite(1),
        Galena(2),
        Nickelite(3),
        Pyrite(4),
        Quartzite(5),
        Uranite(6),
        Azurite(7),
        Rhodonite(8),
        Alfildit(9),
        Euxenite(10),
        Smithsonite(11),
        Ilmenite(12),
        Todorokite(13),
        Ferroaugite(14),
        Sheelite(15);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "basaltheavyore";
        }

        public int getLight() {
            return 0;
        }
    }
}

