/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.utils.ParticleUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

public class RubberLeaves
extends LeavesBlock {
    public RubberLeaves() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((S, W, P, E) -> E == EntityType.OCELOT || E == EntityType.PARROT).isSuffocating((K, V, E) -> false).isViewBlocking((K, V, E) -> false));
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        ParticleUtils.spawnFallingLeavesParticles((Level)pLevel, pPos, (Block)this);
        pLevel.scheduleTick(pPos, (Block)this, pRandom.nextInt(200) + 100);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RenderType getType() {
        return Minecraft.useFancyGraphics() ? RenderType.cutoutMipped() : RenderType.solid();
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder p_60538_) {
        if (!p_60538_.getLevel().isClientSide) {
            ItemStack stack = (ItemStack)p_60538_.getParameter(LootContextParams.TOOL);
            if (stack.is(Tags.Items.TOOLS_SHEAR)) {
                return List.of(new ItemStack((ItemLike)IUItem.leaves.getItem()));
            }
            if (p_60538_.getLevel().random.nextInt(20) == 0) {
                return List.of(new ItemStack((ItemLike)IUItem.rubberSapling.getItem()));
            }
        }
        return super.getDrops(p_60537_, p_60538_);
    }
}

