/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileAdvPump;
import com.denfop.tiles.base.TileAnalyzer;
import com.denfop.tiles.base.TileCombinerMatter;
import com.denfop.tiles.base.TileElectrolyzer;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileFisher;
import com.denfop.tiles.base.TileImpPump;
import com.denfop.tiles.base.TileObsidianGenerator;
import com.denfop.tiles.base.TilePainting;
import com.denfop.tiles.mechanism.TilePlasticCreator;
import com.denfop.tiles.mechanism.TilePlasticPlateCreator;
import com.denfop.tiles.mechanism.exp.TileStorageExp;
import com.denfop.tiles.mechanism.generator.energy.fluid.TileDieselGenerator;
import com.denfop.tiles.mechanism.generator.energy.fluid.TileHydrogenGenerator;
import com.denfop.tiles.mechanism.generator.energy.fluid.TilePetrolGenerator;
import com.denfop.tiles.mechanism.generator.things.fluid.TileHeliumGenerator;
import com.denfop.tiles.mechanism.generator.things.fluid.TileLavaGenerator;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockBaseMachine2 implements IMultiTileBlock,
IMultiBlockItem
{
    combiner_matter(TileCombinerMatter.class, 0),
    fisher(TileFisher.class, 1),
    analyzer(TileAnalyzer.class, 2),
    painter(TilePainting.class, 3),
    gen_disel(TileDieselGenerator.class, 4),
    gen_pet(TilePetrolGenerator.class, 5),
    adv_pump(TileAdvPump.class, 6),
    imp_pump(TileImpPump.class, 7),
    expierence_block(TileStorageExp.class, 8),
    gen_hyd(TileHydrogenGenerator.class, 9),
    gen_obsidian(TileObsidianGenerator.class, 10),
    plastic_creator(TilePlasticCreator.class, 11),
    lava_gen(TileLavaGenerator.class, 12),
    plastic_plate_creator(TilePlasticPlateCreator.class, 13),
    helium_generator(TileHeliumGenerator.class, 14),
    electrolyzer_iu(TileElectrolyzer.class, 15);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockType;

    private BlockBaseMachine2(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = IUCore.instance.modContainer;
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (TileEntityBlock)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public String getMainPath() {
        return "basemachine2";
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 1.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Machine;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    @Override
    public boolean hasUniqueRender(ItemStack itemStack) {
        return false;
    }
}

