/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.IDual;
import com.denfop.api.sytem.IEmitter;
import com.denfop.api.sytem.ISink;
import com.denfop.api.sytem.ISource;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class ComponentBaseEnergy
extends AbstractComponent {
    public final boolean fullEnergy;
    private final EnergyType type;
    private final double defaultCapacity;
    public double capacity;
    public double storage;
    public int sinkTier;
    public int sourceTier;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public List<InvSlot> managedSlots;
    public boolean multiSource;
    public int sourcePackets;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    protected double pastEnergy;
    protected double perenergy;
    Map<Direction, ITile> energyConductorMap = new HashMap<Direction, ITile>();
    List<InfoTile<ITile>> validReceivers = new LinkedList<InfoTile<ITile>>();
    private double perenergy1;
    private double pastEnergy1;
    private double tick1;
    private long id;

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.type = type;
        this.multiSource = false;
        this.sourcePackets = 1;
        this.capacity = capacity;
        this.defaultCapacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<Direction> sinkDirections, List<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.type = type;
        this.multiSource = false;
        this.sourcePackets = 1;
        this.capacity = capacity;
        this.defaultCapacity = capacity;
        this.sinkTier = sinkTier;
        this.sourceTier = sourceTier;
        this.sinkDirections = new HashSet<Direction>(sinkDirections);
        this.sourceDirections = new HashSet<Direction>(sourceDirections);
        this.fullEnergy = fullEnergy;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.tick = 0.0;
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSink(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSource(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    public EnergyType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + this.type.name().toLowerCase();
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.storage = nbt.getDouble("storage");
        this.capacity = nbt.getDouble("capacity");
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.putDouble("storage", this.storage);
        ret.putDouble("capacity", this.capacity);
        return ret;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.capacity < this.defaultCapacity) {
            this.capacity = this.defaultCapacity;
        }
        if (!this.parent.getLevel().isClientSide) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                this.energyConductorMap.clear();
                NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.LOAD, this.type, this.delegate));
            }
            this.loaded = true;
        }
    }

    private void createDelegate() {
        if (this.delegate == null) {
            this.delegate = this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource() : (this.sourceDirections.isEmpty() ? new EnergyNetDelegateSink() : new EnergyNetDelegateDual());
            this.delegate.setLevel(this.parent.getLevel());
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.capacity);
        buffer.writeDouble(this.storage);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.capacity = is.readDouble();
        this.storage = is.readDouble();
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
        if (this.storage > this.capacity) {
            this.storage = capacity;
        }
    }

    public double getEnergy() {
        return this.storage;
    }

    public double getFillRatio() {
        return this.storage / this.capacity;
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.capacity - this.storage, amount);
        this.storage += amount;
        return amount;
    }

    @Override
    public void blockBreak() {
        Level level;
        if (this.getType() == EnergyType.RADIATION && this.parent.getLevel() instanceof ServerLevel) {
            new PacketUpdateRadiationValue(new ChunkPos(this.parent.getBlockPos()), this.storage, (ServerLevel)this.parent.getLevel());
        } else if (this.getType() == EnergyType.EXPERIENCE && this.storage > 0.0 && (level = this.parent.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double f = 0.7;
            double dx = serverLevel.random.nextDouble() * 1.0 + (1.0 - f) * 0.5;
            double dy = serverLevel.random.nextDouble() * f + (1.0 - f) * 0.5;
            double dz = serverLevel.random.nextDouble() * f + (1.0 - f) * 0.5;
            int xpAmount = ExperienceOrb.getExperienceValue((int)((int)this.storage));
            ExperienceOrb xpOrb = new ExperienceOrb((Level)serverLevel, (double)this.parent.getBlockPos().getX() + dx, (double)this.parent.getBlockPos().getY() + dy, (double)this.parent.getBlockPos().getZ() + dz, xpAmount);
            serverLevel.addFreshEntity((Entity)xpOrb);
        }
    }

    public Map<Direction, ITile> getConductors() {
        return this.energyConductorMap;
    }

    public void RemoveTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.parent.getLevel().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public List<InfoTile<ITile>> getValidReceivers() {
        return this.validReceivers;
    }

    public void AddTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.parent.getLevel().isClientSide) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITile>(tile, facing1.getOpposite()));
        }
    }

    public boolean canUseEnergy(double amount) {
        return this.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.storage >= amount) {
            this.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.storage) - amount);
        if (!simulate) {
            this.storage -= ret;
        }
        return ret;
    }

    public int getSinkTier() {
        return this.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.sourceTier = tier;
    }

    public long getIdNetwork() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
        this.receivingDisabled = this.sendingSidabled;
    }

    public void setReceivingEnabled(boolean enabled) {
        this.receivingDisabled = !enabled;
    }

    public void setSendingEnabled(boolean enabled) {
        this.sendingSidabled = !enabled;
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (this.delegate != null) {
            assert (!this.parent.getLevel().isClientSide);
            this.energyConductorMap.clear();
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
        }
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.energyConductorMap.clear();
            this.createDelegate();
        }
        if (this.delegate != null) {
            assert (!this.parent.getLevel().isClientSide);
            this.energyConductorMap.clear();
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.LOAD, this.type, this.delegate));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public ITile getDelegate() {
        return this.delegate;
    }

    private double getSourceEnergy() {
        return this.storage;
    }

    public double getFreeEnergy() {
        return this.capacity - this.storage;
    }

    private abstract class EnergyNetDelegate
    extends BlockEntity
    implements ITile {
        private EnergyNetDelegate(ComponentBaseEnergy componentBaseEnergy) {
            super(componentBaseEnergy.parent.getType(), componentBaseEnergy.parent.getBlockPos(), componentBaseEnergy.parent.getBlockState());
        }
    }

    private class EnergyNetDelegateSource
    extends EnergyNetDelegate
    implements ISource {
        int hashCodeSource;
        boolean hasHashCode;
        private int hashCode;

        private EnergyNetDelegateSource() {
            super(ComponentBaseEnergy.this);
            this.hasHashCode = false;
        }

        public int getSourceTier() {
            return ComponentBaseEnergy.this.sourceTier;
        }

        @Override
        public boolean emitsTo(IAcceptor receiver, Direction dir) {
            return ComponentBaseEnergy.this.sourceDirections.contains(dir);
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<Direction, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return ComponentBaseEnergy.this.parent.getBlockPos();
        }

        @Override
        public double canProvideEnergy() {
            assert (!ComponentBaseEnergy.this.sourceDirections.isEmpty());
            return !ComponentBaseEnergy.this.sendingSidabled ? ComponentBaseEnergy.this.getSourceEnergy() : 0.0;
        }

        @Override
        public BlockEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= ComponentBaseEnergy.this.storage);
            ComponentBaseEnergy.this.useEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }
    }

    private class EnergyNetDelegateSink
    extends EnergyNetDelegate
    implements ISink {
        int hashCodeSource;
        boolean hasHashCode;
        List<ISource> systemTicks;
        private int hashCode;

        private EnergyNetDelegateSink() {
            super(ComponentBaseEnergy.this);
            this.hasHashCode = false;
            this.systemTicks = new LinkedList<ISource>();
        }

        public int getSinkTier() {
            return ComponentBaseEnergy.this.sinkTier;
        }

        @Override
        public boolean acceptsFrom(IEmitter emitter, Direction dir) {
            return ComponentBaseEnergy.this.sinkDirections.contains(dir);
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public List<ISource> getEnergyTickList() {
            return this.systemTicks;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<Direction, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return ComponentBaseEnergy.this.parent.getBlockPos();
        }

        @Override
        public double getDemanded() {
            assert (!ComponentBaseEnergy.this.sinkDirections.isEmpty());
            return !ComponentBaseEnergy.this.receivingDisabled && ComponentBaseEnergy.this.storage < ComponentBaseEnergy.this.capacity ? ComponentBaseEnergy.this.capacity - ComponentBaseEnergy.this.storage : 0.0;
        }

        @Override
        public BlockEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }

        @Override
        public void receivedEnergy(double amount) {
            ComponentBaseEnergy.this.addEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public void addTick(double tick) {
            ComponentBaseEnergy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return ComponentBaseEnergy.this.tick;
        }

        @Override
        public boolean isSink() {
            return true;
        }
    }

    private class EnergyNetDelegateDual
    extends EnergyNetDelegate
    implements IDual {
        List<ISource> systemTicks;
        int hashCodeSource;
        boolean hasHashCode;
        private int hashCode;

        private EnergyNetDelegateDual() {
            super(ComponentBaseEnergy.this);
            this.systemTicks = new LinkedList<ISource>();
            this.hasHashCode = false;
        }

        @Override
        public boolean acceptsFrom(IEmitter emitter, Direction dir) {
            return ComponentBaseEnergy.this.sinkDirections.contains(dir);
        }

        @Override
        public boolean emitsTo(IAcceptor receiver, Direction dir) {
            return ComponentBaseEnergy.this.sourceDirections.contains(dir);
        }

        @Override
        @NotNull
        public BlockPos getPos() {
            return ComponentBaseEnergy.this.parent.getBlockPos();
        }

        @Override
        public double canProvideEnergy() {
            return !ComponentBaseEnergy.this.sendingSidabled && !ComponentBaseEnergy.this.sourceDirections.isEmpty() ? ComponentBaseEnergy.this.getSourceEnergy() : 0.0;
        }

        public int getSinkTier() {
            return ComponentBaseEnergy.this.sinkTier;
        }

        public int getSourceTier() {
            return ComponentBaseEnergy.this.sourceTier;
        }

        @Override
        public double getDemanded() {
            return !ComponentBaseEnergy.this.receivingDisabled && !ComponentBaseEnergy.this.sinkDirections.isEmpty() && ComponentBaseEnergy.this.storage < ComponentBaseEnergy.this.capacity ? ComponentBaseEnergy.this.capacity - ComponentBaseEnergy.this.storage : 0.0;
        }

        @Override
        public void receivedEnergy(double var2) {
            ComponentBaseEnergy.this.addEnergy(var2);
        }

        @Override
        public double getPerEnergy1() {
            return ComponentBaseEnergy.this.perenergy1;
        }

        @Override
        public double getPastEnergy1() {
            return ComponentBaseEnergy.this.pastEnergy1;
        }

        @Override
        public void setPastEnergy1(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy1 = pastEnergy;
        }

        @Override
        public void addPerEnergy1(double setEnergy) {
            ComponentBaseEnergy.this.perenergy1 += setEnergy;
        }

        @Override
        public void addTick1(double tick) {
            ComponentBaseEnergy.this.tick1 = tick;
        }

        @Override
        public double getTick1() {
            return ComponentBaseEnergy.this.tick1;
        }

        @Override
        public void extractEnergy(double amount) {
            assert (amount <= ComponentBaseEnergy.this.storage);
            ComponentBaseEnergy.this.useEnergy(amount);
        }

        @Override
        public double getPerEnergy() {
            return ComponentBaseEnergy.this.perenergy;
        }

        @Override
        public double getPastEnergy() {
            return ComponentBaseEnergy.this.pastEnergy;
        }

        @Override
        public void setPastEnergy(double pastEnergy) {
            ComponentBaseEnergy.this.pastEnergy = pastEnergy;
        }

        @Override
        public void addPerEnergy(double setEnergy) {
            ComponentBaseEnergy.this.perenergy += setEnergy;
        }

        @Override
        public boolean isSource() {
            return true;
        }

        @Override
        public void addTick(double tick) {
            ComponentBaseEnergy.this.tick = tick;
        }

        @Override
        public double getTick() {
            return ComponentBaseEnergy.this.tick;
        }

        @Override
        public boolean isSink() {
            return true;
        }

        @Override
        public List<ISource> getEnergyTickList() {
            return this.systemTicks;
        }

        @Override
        public long getIdNetwork() {
            return ComponentBaseEnergy.this.getIdNetwork();
        }

        @Override
        public int getHashCodeSource() {
            return this.hashCodeSource;
        }

        @Override
        public void setHashCodeSource(int hashCode) {
            this.hashCodeSource = hashCode;
        }

        @Override
        public void setId(long id) {
            ComponentBaseEnergy.this.setId(id);
        }

        @Override
        public void AddTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.AddTile(type, tile, dir);
        }

        @Override
        public void RemoveTile(EnergyType type, ITile tile, Direction dir) {
            ComponentBaseEnergy.this.RemoveTile(type, tile, dir);
        }

        @Override
        public Map<Direction, ITile> getTiles(EnergyType energyType) {
            return ComponentBaseEnergy.this.energyConductorMap;
        }

        @Override
        public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
            return ComponentBaseEnergy.this.validReceivers;
        }

        @Override
        public BlockEntity getTile() {
            return ComponentBaseEnergy.this.parent;
        }
    }
}

