/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.container.ContainerBase;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.ItemStackInventory;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerHandHeldInventory<T extends ItemStackInventory>
extends ContainerBase<T> {
    public ContainerHandHeldInventory(T inventory, Player player) {
        super(inventory, player);
        if (player != null) {
            this.inventory = player.getInventory();
        }
    }

    protected void addPlayerInventorySlots(Player player, int width, int height) {
        int col;
        int xStart = (width - 162) / 2;
        for (col = 0; col < 3; ++col) {
            for (int col1 = 0; col1 < 9; ++col1) {
                this.addSlotToContainer(new Slot((Container)player.getInventory(), col1 + col * 9 + 9, xStart + col1 * 18, height + -82 + col * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlotToContainer(new Slot((Container)player.getInventory(), col, xStart + col * 18, height + -24));
        }
    }

    @Override
    public void clicked(int slot, int button, ClickType type, Player player) {
        ItemStack held;
        boolean closeGUI = false;
        block0 : switch (type) {
            case CLONE: 
            case PICKUP_ALL: 
            case QUICK_CRAFT: {
                break;
            }
            case PICKUP: 
            case THROW: {
                if (slot < 0 || slot >= this.slots.size()) break;
                closeGUI = ((ItemStackInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                break;
            }
            case QUICK_MOVE: {
                if (slot < 0 || slot >= this.slots.size() || !((ItemStackInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) break;
                this.setCarried(ModUtils.emptyStack);
                break;
            }
            case SWAP: {
                assert (this.getSlotFromInventory((Container)player.getInventory(), button) != null);
                boolean swapOut = ((ItemStackInventory)this.base).isThisContainer(this.getSlotFromInventory((Container)player.getInventory(), button).getItem());
                boolean swapTo = ((ItemStackInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                if (!swapOut && !swapTo) break;
                for (int i = 0; i < 9; ++i) {
                    if ((!swapOut || slot != Objects.requireNonNull(this.getSlotFromInventory((Container)player.getInventory(), (int)i)).index) && (!swapTo || button != i)) continue;
                    if (!(player instanceof ServerPlayer)) break block0;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundSetCarriedItemPacket(i));
                    break block0;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ClickType: " + String.valueOf(type));
            }
        }
        super.clicked(slot, button, type, player);
        ItemStack stack = this.getCarried();
        if (closeGUI && !player.level().isClientSide()) {
            ((ItemStackInventory)this.base).saveAsThrown(stack);
            player.closeContainer();
        } else if (type == ClickType.CLONE && ((ItemStackInventory)this.base).isThisContainer(held = player.getInventory().getSelected())) {
            ((ContainerItem)held.getOrDefault(DataComponentsInit.CONTAINER, (Object)ContainerItem.EMPTY)).updateUUID(held, 0);
        }
        this.setCarried(stack);
    }
}

