/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.datacomponent.DataComponentsInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.codec.StreamCodec;

public record GenomeBee(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
    public static final Codec<GenomeBee> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.INT).fieldOf("traits_ordinals").forGetter(genome -> genome.geneticTraitsMap.values().stream().map(Enum::ordinal).collect(Collectors.toList()))).apply((Applicative)instance, GenomeBee::newFromOrdinals));
    public static final StreamCodec<ByteBuf, GenomeBee> STREAM_CODEC = StreamCodec.composite(DataComponentsInit.INT_ARRAY, GenomeBee::toIntList, GenomeBee::newFromOrdinals);

    private static List<Integer> toIntList(GenomeBee genome) {
        return genome.geneticTraitsMap().values().stream().map(Enum::ordinal).collect(Collectors.toList());
    }

    private static GenomeBee newFromOrdinals(List<Integer> ordinals) {
        HashMap<EnumGenetic, GeneticTraits> map = new HashMap<EnumGenetic, GeneticTraits>();
        for (int ord : ordinals) {
            GeneticTraits gt = GeneticTraits.values()[ord];
            map.put(gt.getGenetic(), gt);
        }
        return new GenomeBee(map);
    }
}

