/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen.blocktags;

import com.denfop.IUItem;
import com.denfop.datagen.blocktags.IBlockTag;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import oshi.util.tuples.Pair;

public class BlockTagsProvider
extends net.neoforged.neoforge.common.data.BlockTagsProvider {
    public static List<IBlockTag> list = new LinkedList<IBlockTag>();
    private final String key;

    public BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        this(packOutput, lookupProvider, "industrialupgrade", existingFileHelper);
    }

    public BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, modid, existingFileHelper);
        this.key = modid;
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (IBlockTag tag : list) {
            Pair<String, Integer> pair;
            Block block = tag.getBlock();
            if (!BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace().equals(this.key) || (pair = tag.getHarvestLevel()).getA() == null) continue;
            TagKey<Block> blockTagKey = this.getToolFromString((String)pair.getA());
            TagKey<Block> level = this.getLevelFromInteger((Integer)pair.getB());
            this.tag(blockTagKey).add((Object)block);
            this.tag(level).add((Object)block);
        }
        if (this.key.equals("industrialupgrade")) {
            this.tag(BlockTags.LOGS).add((Object)((Block)IUItem.swampRubWood.getBlock().get()));
            this.tag(BlockTags.LOGS).add((Object)((Block)IUItem.rubWood.getBlock().get()));
            this.tag(BlockTags.LOGS).add((Object)((Block)IUItem.tropicalRubWood.getBlock().get()));
            this.tag(BlockTags.LEAVES).add((Object)((Block)IUItem.leaves.getBlock().get()));
            this.tag(BlockTags.SAPLINGS).add((Object)((Block)IUItem.rubberSapling.getBlock().get()));
        }
    }

    private TagKey<Block> getLevelFromInteger(Integer b) {
        return switch (b) {
            default -> Tags.Blocks.NEEDS_WOOD_TOOL;
            case 1 -> BlockTags.NEEDS_STONE_TOOL;
            case 2 -> BlockTags.NEEDS_IRON_TOOL;
            case 3 -> BlockTags.NEEDS_DIAMOND_TOOL;
        };
    }

    private TagKey<Block> getToolFromString(String a) {
        return switch (a) {
            case "pickaxe" -> BlockTags.MINEABLE_WITH_PICKAXE;
            case "axe" -> BlockTags.MINEABLE_WITH_AXE;
            case "shovel" -> BlockTags.MINEABLE_WITH_SHOVEL;
            default -> BlockTags.MINEABLE_WITH_PICKAXE;
        };
    }
}

