/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerBlastFurnace;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.blastfurnace.block.TileBlastFurnaceMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiBlastFurnace<T extends ContainerBlastFurnace>
extends GuiIU<ContainerBlastFurnace> {
    public final ContainerBlastFurnace container;
    public boolean highlightedMinus = false;
    public boolean highlightedPlus = false;

    public GuiBlastFurnace(ContainerBlastFurnace container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.imageHeight = 182;
        this.addComponent(new GuiComponent(this, 142, 74, EnumTypeComponent.SOUND_BUTTON, new com.denfop.api.gui.Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addElement((GuiElement<?>)new AdvArea(this, 137, 23, 150, 36).withTooltip("+1"));
        this.addElement((GuiElement<?>)new AdvArea(this, 63, 23, 76, 36).withTooltip("-1"));
        this.addElement(new AdvArea(this, 79, 76, 134, 89){

            @Override
            protected List<String> getToolTip() {
                if (((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).heat == null) {
                    return Collections.singletonList("0/0 \u00b0C");
                }
                HeatComponent component = ((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).heat;
                ArrayList<String> stringList = new ArrayList<String>();
                stringList.add(ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C");
                if (component.need) {
                    stringList.add(Localization.translate("iu.need_heat"));
                }
                return stringList;
            }
        });
        this.addElement(new AdvArea(this, 79, 25, 134, 34){

            @Override
            protected List<String> getToolTip() {
                String temp = ModUtils.getString((double)((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).bar * 100000.0) + " Pa";
                return Collections.singletonList(temp);
            }
        });
        this.addElement(new AdvArea(this, 88, 46, 125, 57){

            @Override
            protected List<String> getToolTip() {
                return Collections.singletonList(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(Math.min(((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).getProgress() / 3600.0, 1.0) * 100.0) + "%");
            }
        });
        this.addElement(new TankGauge(this, 6, 18, 20, 55, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank1, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank1 == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank1.getFluid();
                    if (!fs.isEmpty() && fs.getAmount() > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(Localization.translate(fluid.getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                if (((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank1 == null) {
                    return;
                }
                4.bindCommonTexture();
                FluidStack fs = ((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank1.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 48;
                    }
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 4.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    4.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        4.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
                    }
                }
            }
        });
        this.addElement(new TankGauge(this, 30, 18, 20, 55, (IFluidTank)((TileBlastFurnaceMain)this.container.base).tank, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank.getFluid();
                    if (!fs.isEmpty() && fs.getAmount() > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(Localization.translate(fluid.getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                if (((TileBlastFurnaceMain)GuiBlastFurnace.this.container.base).tank == null) {
                    return;
                }
                5.bindCommonTexture();
                FluidStack fs = this.tank.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 48;
                    }
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 5.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    5.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        5.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
                    }
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.blast_furnace_recipe.info"));
            List<String> compatibleUpgrades = ListInformationUtils.blast_furnace;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.highlightedMinus = false;
        this.highlightedPlus = false;
        if (par1 >= 63 && par2 >= 23 && par1 <= 76 && par2 <= 36) {
            this.highlightedMinus = true;
        }
        if (par1 >= 137 && par2 >= 23 && par1 <= 150 && par2 <= 36) {
            this.highlightedPlus = true;
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 63 && x <= 76 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 1.0);
        }
        if (x >= 137 && x <= 150 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 0.0);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        String name = Localization.translate(((TileBlastFurnaceMain)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2 + 20, 6, Component.nullToEmpty((String)name), 0x404040, false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiBlastFurnace.bindTexture(this.getTexture());
        int progress = (int)(38.0 * ((TileBlastFurnaceMain)this.container.base).getProgress() / 3600.0);
        int xoffset = (this.width - this.imageWidth) / 2;
        int yoffset = (this.height - this.imageHeight) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBlastFurnace.bindTexture(this.getTexture());
        if (this.highlightedMinus) {
            this.drawTexturedModalRect(poseStack, xoffset + 63, yoffset + 23, 192, 3, 14, 14);
        }
        if (this.highlightedPlus) {
            this.drawTexturedModalRect(poseStack, xoffset + 137, yoffset + 23, 177, 3, 14, 14);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 88, yoffset + 46, 177, 19, progress, 11);
        }
        GuiBlastFurnace.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        GuiBlastFurnace.bindTexture(this.getTexture());
        int bar = (int)(Math.min((double)((TileBlastFurnaceMain)this.container.base).bar * 1.0, 5.0) / 5.0 * 50.0);
        if (bar > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 82, this.guiTop + 28, 181, 53, bar, 5);
        }
        if (((TileBlastFurnaceMain)this.container.base).heat != null) {
            progress = (int)(50.0 * ((TileBlastFurnaceMain)this.container.base).heat.getFillRatio());
            this.drawTexturedModalRect(poseStack, this.guiLeft + 82, this.guiTop + 79, 180, 34, progress, 8);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiblastfurnace.png");
    }
}

