/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.GuiSlider;
import com.denfop.api.gui.GuiVerticalSlider;
import com.denfop.api.gui.GuiVerticalSliderList;
import com.denfop.api.gui.MouseButton;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.container.ContainerBase;
import com.denfop.container.SlotInvSlot;
import com.denfop.mixin.access.AbstractContainerScreenAccessor;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public abstract class GuiCore<T extends ContainerBase<? extends IAdvInventory>>
extends AbstractContainerScreen<T>
implements MenuAccess<T> {
    public static final int textHeight = 8;
    public static ResourceLocation currentTexture;
    protected static Runnable closeHandler;
    public final T container;
    protected final List<GuiElement<?>> elements;
    private final Queue<Tooltip> queuedTooltips;
    public int guiLeft;
    public int guiTop;
    public Component title;
    private boolean fixKeyEvents = false;

    public GuiCore(T container) {
        this(container, 176, 166);
    }

    public GuiCore(T container, int ySize) {
        this(container, 176, ySize);
    }

    public GuiCore(T t, int n, int n2) {
        super(t, ((ContainerBase)((Object)t)).getInventory(), (Component)Component.empty());
        this.container = t;
        this.queuedTooltips = new ArrayDeque<Tooltip>();
        this.elements = new ArrayList();
        this.imageHeight = n2;
        this.imageWidth = n;
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.getItem();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        currentTexture = resourceLocation;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
    }

    public static void bindTexture(int i, ResourceLocation resourceLocation) {
        currentTexture = resourceLocation;
        RenderSystem.setShaderTexture((int)i, (ResourceLocation)resourceLocation);
    }

    public void drawSplitString(GuiGraphics poseStack, Font font, String str, int x, int y, int wrapWidth, int textColor) {
        List strs = font.split(FormattedText.of((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            poseStack.drawString(font, s, x, y, textColor, false);
            y += 9;
        }
    }

    public void changeParams() {
    }

    public void drawSplitString(GuiGraphics poseStack, String str, int x, int y, int wrapWidth, int textColor) {
        if (this.font == null) {
            this.font = Minecraft.getInstance().font;
        }
        List strs = this.font.split(FormattedText.of((String)str), wrapWidth);
        for (FormattedCharSequence s : strs) {
            poseStack.drawString(this.font, s, x, y, textColor, false);
            y += 9;
        }
    }

    public float adjustTextScale(String text, int canvasWidth, int canvasHeight, float scale, float scaleStep) {
        float newScale;
        block4: {
            newScale = scale;
            float min = 70.0f;
            float max = 0.0f;
            boolean prevScaleDecrease = false;
            boolean prevScaleIncrease = false;
            while (true) {
                if (newScale < min) {
                    min = newScale;
                }
                if (newScale > max) {
                    max = newScale;
                }
                List<String> lines = this.splitTextToLines(text, canvasWidth, newScale);
                int n = lines.size();
                Objects.requireNonNull(this.font);
                int totalTextHeight = (int)((float)(n * 9) * newScale);
                if (this.isTextTooLarge(lines, canvasWidth, canvasHeight, newScale)) {
                    newScale *= 1.0f - scaleStep;
                    prevScaleDecrease = true;
                    if (!prevScaleIncrease) continue;
                    newScale = (min + max) * 0.95f / 2.0f;
                    break block4;
                }
                if (!((float)totalTextHeight < (float)canvasHeight * 0.8f)) break block4;
                prevScaleIncrease = true;
                newScale *= 1.0f + scaleStep;
                if (prevScaleDecrease) break;
            }
            newScale = (min + max) * 1.2f / 2.0f;
        }
        return newScale;
    }

    public boolean isTextTooLarge(List<String> lines, int canvasWidth, int canvasHeight, float scale) {
        int n = lines.size();
        Objects.requireNonNull(this.font);
        int totalHeight = (int)((float)(n * 9) * scale);
        for (String line : lines) {
            int lineWidth = (int)((float)this.font.width(line) * scale);
            if (lineWidth <= canvasWidth) continue;
            return true;
        }
        return totalHeight > canvasHeight;
    }

    public List<String> wrapTextWithNewlines(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\n")) {
            lines.addAll(this.wrapText(paragraph, maxWidth));
        }
        return lines;
    }

    public List<String> wrapText(String text, int maxWidth) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (this.font.width(String.valueOf(currentLine) + word) <= maxWidth) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine.setLength(0);
            currentLine.append(word).append(" ");
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    public void drawTextInCanvas(GuiGraphics graphics, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.font);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        PoseStack poseStack = graphics.pose();
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.pushPose();
            poseStack.scale(scale, scale, scale);
            graphics.drawString(this.font, line, (int)((float)x / scale), (int)((float)y / scale), 0xFFFFFF, false);
            poseStack.popPose();
            y += lineHeight;
        }
    }

    public void drawTextInCanvas(GuiGraphics graphics, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, float scale, int color) {
        int maxWidth = (int)((float)canvasWidth / scale);
        Objects.requireNonNull(this.font);
        int lineHeight = (int)(9.0f * scale);
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.wrapTextWithNewlines(text, maxWidth);
        PoseStack poseStack = graphics.pose();
        for (String line : lines) {
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.pushPose();
            poseStack.scale(scale, scale, scale);
            graphics.drawString(this.font, line, (int)((float)x / scale), (int)((float)y / scale), color, false);
            poseStack.popPose();
            y += lineHeight;
        }
    }

    public List<String> splitTextToLines(String text, int canvasWidth, float scale) {
        String[] manualLines;
        ArrayList<String> lines = new ArrayList<String>();
        for (String manualLine : manualLines = text.split("\n")) {
            String[] words;
            StringBuilder currentLine = new StringBuilder();
            for (String word : words = manualLine.split(" ")) {
                Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
                int lineWidth = (int)((float)this.font.width((String)testLine) * scale);
                if (lineWidth > canvasWidth) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                    continue;
                }
                currentLine.append((String)(currentLine.isEmpty() ? word : " " + word));
            }
            if (currentLine.isEmpty()) continue;
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public final T getContainer() {
        return (T)((Object)((ContainerBase)this.menu));
    }

    public final int guiLeft() {
        return this.leftPos;
    }

    public final int guiTop() {
        return this.topPos;
    }

    public final Slot getFocusedSlot() {
        return this.hoveredSlot;
    }

    public boolean isHovering(Slot p_97775_, double p_97776_, double p_97777_) {
        return this.isHovering(p_97775_.x, p_97775_.y, 16, 16, p_97776_, p_97777_);
    }

    public void renderFloatingItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 232.0f);
        guiGraphics.renderItem(stack, x, y);
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.ITEM_COUNT);
        guiGraphics.renderItemDecorations(font == null ? this.font : font, stack, x, y - (((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() ? 0 : 8), text);
        guiGraphics.pose().popPose();
    }

    public void renderItemTooltipGrid(GuiGraphics graphics, List<IInputItemStack> items, int mouseX, int mouseY) {
        int columns;
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = this.width - mouseX;
        int screenHeight = this.height - mouseY;
        int itemSize = 18;
        int padding = 6;
        int maxColumns = Math.min(12, Math.max(1, (screenWidth - 20) / itemSize));
        int itemsPerRow = columns = Math.min(maxColumns, items.size());
        int maxRows = Math.max(1, (screenHeight - 40) / itemSize);
        int itemsPerPage = itemsPerRow * maxRows;
        int totalPages = (int)Math.ceil((double)items.size() / (double)itemsPerPage);
        if (totalPages <= 0) {
            totalPages = 1;
        }
        int currentPage = (int)(System.currentTimeMillis() / 2000L % (long)totalPages);
        int startIndex = currentPage * itemsPerPage;
        int endIndex = Math.min(startIndex + itemsPerPage, items.size());
        List<IInputItemStack> visibleItems = items.subList(startIndex, endIndex);
        int rows = (int)Math.ceil((double)visibleItems.size() / (double)columns);
        int tooltipWidth = columns * itemSize + padding * 2;
        int tooltipHeight = rows * itemSize + padding * 2;
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + tooltipWidth > screenWidth) {
            x = screenWidth - tooltipWidth - 4;
        }
        if (y + tooltipHeight > screenHeight) {
            y = screenHeight - tooltipHeight - 4;
        }
        if (x < 4) {
            x = 4;
        }
        if (y < 4) {
            y = 4;
        }
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)graphics, (int)x, (int)y, (int)tooltipWidth, (int)tooltipHeight, (int)400);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        RenderSystem.enableDepthTest();
        long tick = System.currentTimeMillis() / 1000L;
        for (int i = 0; i < visibleItems.size(); ++i) {
            int col = i % columns;
            int row = i / columns;
            int drawX = x + padding + col * itemSize;
            int drawY = y + padding + row * itemSize;
            List<ItemStack> stacks = visibleItems.get(i).getInputs();
            ItemStack stack = stacks.get((int)(tick % (long)stacks.size()));
            graphics.renderItem(stack, drawX, drawY);
        }
        RenderSystem.disableDepthTest();
        graphics.pose().popPose();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        this.guiLeft = this.getGuiLeft();
        this.guiTop = this.getGuiTop();
        this.renderTransparentBackground(guiGraphics);
        int i = this.leftPos;
        int j = this.topPos;
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        RenderSystem.disableDepthTest();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)i, (float)j, 0.0f);
        this.hoveredSlot = null;
        for (int k = 0; k < ((ContainerBase)this.menu).slots.size(); ++k) {
            Slot slot = (Slot)((ContainerBase)this.menu).slots.get(k);
            if (slot.isActive()) {
                this.renderSlot(guiGraphics, slot);
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            this.hoveredSlot = slot;
            int j2 = slot.x;
            int k2 = slot.y;
            if (this.hoveredSlot.isHighlightable()) {
                GuiCore.renderSlotHighlight((GuiGraphics)guiGraphics, (int)j2, (int)k2, (int)0, (int)this.getSlotColor(k));
            }
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).invSlot.hasItemList() || !Keyboard.isKeyDown(340)) continue;
            this.renderItemTooltipGrid(guiGraphics, ((SlotInvSlot)slot).invSlot.getStacks(((SlotInvSlot)slot).index), mouseX - this.guiLeft + 5, mouseY - this.guiTop + 5);
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() ? ((ContainerBase)this.menu).getCarried() : ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem();
        if (!itemstack.isEmpty()) {
            int j2 = ((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() ? 8 : 16;
            String s = null;
            if (!((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() && ((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack()) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType())).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - j2, s);
        }
        if (!((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem().isEmpty()) {
            float f = (float)(Util.getMillis() - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackTime()) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                ((AbstractContainerScreenAccessor)((Object)this)).setSnapbackItem(ItemStack.EMPTY);
            }
            int j2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().x - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX();
            int k2 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackEnd().y - ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY();
            int j1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartX() + (int)((float)j2 * f);
            int k1 = ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackStartY() + (int)((float)k2 * f);
            this.renderFloatingItem(guiGraphics, ((AbstractContainerScreenAccessor)((Object)this)).getSnapbackItem(), j1, k1, null);
        }
        guiGraphics.pose().popPose();
        RenderSystem.enableDepthTest();
        this.changeParams();
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        Pair pair;
        int i = slot.x;
        int j = slot.y;
        ItemStack itemstack = slot.getItem();
        boolean flag = false;
        boolean flag1 = slot == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() && !((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack();
        ItemStack itemstack1 = ((ContainerBase)this.menu).getCarried();
        String s = null;
        if (slot == ((AbstractContainerScreenAccessor)((Object)this)).getClickedSlot() && !((AbstractContainerScreenAccessor)((Object)this)).getDraggingItem().isEmpty() && ((AbstractContainerScreenAccessor)((Object)this)).getIsSplittingStack() && !itemstack.isEmpty()) {
            itemstack = itemstack.copyWithCount(itemstack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !itemstack1.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)itemstack1, (boolean)true) && ((ContainerBase)this.menu).canDragTo(slot)) {
                flag = true;
                int k = Math.min(itemstack1.getMaxStackSize(), slot.getMaxStackSize(itemstack1));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int i1 = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack1) + l;
                if (i1 > k) {
                    i1 = k;
                    String var10000 = ChatFormatting.YELLOW.toString();
                    s = var10000 + k;
                }
                itemstack = itemstack1.copyWithCount(i1);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (itemstack.isEmpty() && slot.isActive() && (pair = slot.getNoItemIcon()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            guiGraphics.blit(i, j, 0, 16, 16, textureatlassprite);
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                guiGraphics.fill(i, j, i + 16, j + 16, -2130706433);
            }
            guiGraphics.renderItem(itemstack, i, j, slot.x + slot.y * this.imageWidth);
            guiGraphics.renderItemDecorations(this.font, itemstack, i, j, s);
        }
        guiGraphics.pose().popPose();
    }

    public void recalculateQuickCraftRemaining() {
        ItemStack itemstack = ((ContainerBase)this.menu).getCarried();
        if (!itemstack.isEmpty() && this.isQuickCrafting) {
            if (((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType() == 2) {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(itemstack.getMaxStackSize());
            } else {
                ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(itemstack.getCount());
                for (Slot slot : this.quickCraftSlots) {
                    ItemStack itemstack1 = slot.getItem();
                    int i = itemstack1.isEmpty() ? 0 : itemstack1.getCount();
                    int j = Math.min(itemstack.getMaxStackSize(), slot.getMaxStackSize(itemstack));
                    int k = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingType(), (ItemStack)itemstack) + i, j);
                    ((AbstractContainerScreenAccessor)((Object)this)).setQuickCraftingRemainder(((AbstractContainerScreenAccessor)((Object)this)).getQuickCraftingRemainder() - (k - i));
                }
            }
        }
    }

    public void containerTick() {
        super.containerTick();
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.tick();
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        if (this.font == null) {
            this.font = Minecraft.getInstance().font;
        }
        if (this.title == null) {
            this.title = Component.empty();
        }
        this.drawBackgroundAndTitle(graphics, partialTick, mouseX - this.leftPos, mouseY - this.topPos);
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawBackground(graphics, this.leftPos, this.topPos);
        }
    }

    public void drawItemStack(GuiGraphics graphics, int x, int y, ItemStack stack) {
        graphics.renderItem(stack, x + this.guiLeft(), y + this.guiTop());
        graphics.renderItemDecorations(this.font, stack, x + this.guiLeft(), y + this.guiTop());
    }

    public void drawItemStack(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.renderItem(stack, x + this.guiLeft(), y + this.guiTop());
        graphics.renderItemDecorations(this.font, stack, x + this.guiLeft(), y + this.guiTop());
    }

    protected void drawBackgroundAndTitle(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        GuiCore.bindTexture(this.getTexture());
        graphics.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        graphics.drawCenteredString(this.font, this.title, this.imageWidth / 2, 6, 0x404040);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        this.drawForegroundLayer(graphics, mouseX - this.leftPos, mouseY - this.topPos);
        this.flushTooltips(graphics);
        this.renderTooltip(graphics, mouseX - this.leftPos, mouseY - this.topPos - 5);
    }

    protected void draw(GuiGraphics poseStack, String s, int i, int i1, int i2) {
        poseStack.drawString(Minecraft.getInstance().font, s, i, i1, i2, false);
    }

    protected void draw(GuiGraphics poseStack, FormattedCharSequence s, int i, int i1, int i2) {
        poseStack.drawString(Minecraft.getInstance().font, s, i, i1, i2, false);
    }

    protected void draw(GuiGraphics poseStack, Component s, int i, int i1, int i2) {
        poseStack.drawString(Minecraft.getInstance().font, s, i, i1, i2, false);
    }

    protected void drawForegroundLayer(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (((ContainerBase)this.menu).base instanceof IUpgradableBlock) {
            this.handleUpgradeTooltip(mouseX, mouseY);
        }
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            guiElement.drawForeground(graphics, mouseX, mouseY);
        }
    }

    private void handleUpgradeTooltip(int n, int n2) {
        if (n >= 0 && n <= 12 && n2 >= 0 && n2 <= 12) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack itemStack : GuiCore.getCompatibleUpgrades((IUpgradableBlock)((ContainerBase)this.menu).base)) {
                arrayList.add(itemStack.getHoverName().getString());
            }
            this.drawTooltip(n, n2, arrayList);
        }
    }

    public boolean mouseScrolled(double d, double d2, double d4, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible() || !guiElement.contains((int)d, (int)d2)) continue;
            guiElement.onMouseScroll((int)d, (int)d2, scrollDirection);
        }
        List listButton = this.renderables;
        for (Renderable button : listButton) {
            AbstractWidget slider;
            if (button instanceof GuiVerticalSliderList) {
                slider = (GuiVerticalSliderList)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (button instanceof GuiSlider) {
                slider = (GuiSlider)button;
                if (scrollDirection != ScrollDirection.stopped) {
                    slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
                }
            }
            if (!(button instanceof GuiVerticalSlider)) continue;
            slider = (GuiVerticalSlider)button;
            if (scrollDirection == ScrollDirection.stopped) continue;
            slider.handleMouseWheel(scrollDirection, (int)d, (int)d2);
        }
        return super.mouseScrolled(d, d2, d4, d3);
    }

    protected void mouseClicked(int i, int j, int k) {
        for (Renderable widget : this.renderables) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).mouseClicked((double)i, (double)j, k);
        }
    }

    public boolean mouseClicked(double d, double d2, int n) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.leftPos;
        d2 -= (double)this.topPos;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseClick((int)d, (int)d2, mouseButton, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        this.mouseClicked((int)(d += (double)this.leftPos), (int)(d2 += (double)this.topPos), n);
        return super.mouseClicked(d, d2, n);
    }

    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.leftPos;
        d2 -= (double)this.topPos;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseDrag((int)d, (int)d2, mouseButton, (long)d3, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        d += (double)this.leftPos;
        d2 += (double)this.topPos;
        for (Renderable widget : this.renderables) {
            if (!(widget instanceof GuiEventListener)) continue;
            ((GuiEventListener)widget).mouseDragged(d, d2, n, d3, d4);
        }
        return super.mouseDragged(d, d2, n, d3, d4);
    }

    public boolean mouseReleased(double d, double d2, int n) {
        MouseButton mouseButton = MouseButton.get(n);
        boolean bl = false;
        d -= (double)this.leftPos;
        d2 -= (double)this.topPos;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onMouseRelease((int)d, (int)d2, mouseButton, guiElement.contains((int)d, (int)d2));
        }
        if (bl) {
            return true;
        }
        return super.mouseReleased(d += (double)this.leftPos, d2 += (double)this.topPos, n);
    }

    public boolean charTyped(char c, int n) {
        boolean bl = false;
        for (GuiElement<?> element : this.elements) {
            GuiElement<?> guiElement = element;
            if (!guiElement.visible()) continue;
            bl |= guiElement.onKeyTyped(c, n);
        }
        if (bl) {
            return true;
        }
        return super.charTyped(c, n);
    }

    public void removed() {
        super.removed();
        if (closeHandler != null) {
            closeHandler.run();
        }
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double texX, double texY) {
        this.drawTexturedRect(graphics, x, y, width, height, texX, texY, false);
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double texX, double texY, boolean mirrorX) {
        this.drawTexturedRect(graphics, x, y, width, height, texX / 256.0, texY / 256.0, (texX + width) / 256.0, (texY + height) / 256.0, mirrorX);
    }

    public void drawTexturedRect(GuiGraphics graphics, double x, double y, double width, double height, double uS, double vS, double uE, double vE, boolean mirrorX) {
        double xE = (x += (double)this.guiLeft()) + width;
        double yE = (y += (double)this.guiTop()) + height;
        if (mirrorX) {
            double tmp = uS;
            uS = uE;
            uE = tmp;
        }
        graphics.blit(currentTexture, (int)x, (int)y, (int)uS, (int)vS, (int)width, (int)height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = graphics.pose().last().pose();
        bufferBuilder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv((float)uS, (float)vS);
        bufferBuilder.addVertex(matrix, (float)x, (float)yE, 0.0f).setUv((float)uS, (float)vE);
        bufferBuilder.addVertex(matrix, (float)xE, (float)yE, 0.0f).setUv((float)uE, (float)vE);
        bufferBuilder.addVertex(matrix, (float)xE, (float)y, 0.0f).setUv((float)uE, (float)vS);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public void drawSprite(GuiGraphics graphics, double x, double y, double width, double height, TextureAtlasSprite sprite, int color, double textureSize, boolean wrapX, boolean wrapY) {
        double tileWidth;
        if (sprite == null) {
            sprite = ((TextureAtlas)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS)).getSprite(MissingTextureAtlasSprite.getLocation());
        }
        double startX = x;
        double startY = y;
        double tileSize = 16.0;
        double u0 = sprite.getU0();
        double v0 = sprite.getV0();
        double u1 = sprite.getU1();
        double v1 = sprite.getV1();
        double uSize = u1 - u0;
        double vSize = v1 - v0;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        double remX = width % tileSize;
        double remY = height % tileSize;
        for (double tileX = startX; tileX < startX + width; tileX += tileWidth) {
            double tileHeight;
            tileWidth = tileSize;
            double uStart = u0;
            if (tileX == startX && remX > 0.0) {
                tileWidth = remX;
                uStart = u0 + uSize * (1.0 - remX / tileSize);
            }
            if (tileX + tileWidth > startX + width) {
                tileWidth = startX + width - tileX;
                uStart = u0;
            }
            double tileXEnd = tileX + tileWidth;
            double uEnd = uStart + (tileXEnd - tileX) / tileSize * uSize;
            for (double tileY = startY; tileY < startY + height; tileY += tileHeight) {
                tileHeight = tileSize;
                double vStart = v0;
                if (tileY == startY && remY > 0.0) {
                    tileHeight = remY;
                    vStart = v0 + vSize * (1.0 - remY / tileSize);
                }
                if (tileY + tileHeight > startY + height) {
                    tileHeight = startY + height - tileY;
                    vStart = v0;
                }
                double tileYEnd = tileY + tileHeight;
                double vEnd = vStart + (tileYEnd - tileY) / tileSize * vSize;
                buffer.addVertex(matrix, (float)tileX, (float)tileY, 0.0f).setUv((float)uStart, (float)vStart).setColor(red, green, blue, alpha);
                buffer.addVertex(matrix, (float)tileX, (float)tileYEnd, 0.0f).setUv((float)uStart, (float)vEnd).setColor(red, green, blue, alpha);
                buffer.addVertex(matrix, (float)tileXEnd, (float)tileYEnd, 0.0f).setUv((float)uEnd, (float)vEnd).setColor(red, green, blue, alpha);
                buffer.addVertex(matrix, (float)tileXEnd, (float)tileY, 0.0f).setUv((float)uEnd, (float)vStart).setColor(red, green, blue, alpha);
            }
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public void drawItem(GuiGraphics graphics, int x, int y, ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        graphics.renderItem(itemStack, x + this.guiLeft(), y + this.guiTop());
    }

    public void drawColoredRect(GuiGraphics poseStack, int x, int y, int width, int height, int color, BufferBuilder bufferBuilder) {
        int alpha = color >>> 24;
        boolean translucent = alpha != 255 && alpha != 0;
        Matrix4f matrix4f = poseStack.pose().last().pose();
        int x2 = (x += this.leftPos) + width;
        int y2 = (y += this.topPos) + height;
        boolean z = false;
        if (translucent) {
            RenderSystem.enableBlend();
        }
        bufferBuilder.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(color);
        bufferBuilder.addVertex(matrix4f, (float)x, (float)y2, (float)z).setColor(color);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y2, (float)z).setColor(color);
        bufferBuilder.addVertex(matrix4f, (float)x2, (float)y, (float)z).setColor(color);
        if (translucent) {
            RenderSystem.disableBlend();
        }
    }

    public int drawString(GuiGraphics poseStack, String text, int x, int y, int color) {
        if (this.font == null) {
            this.font = Minecraft.getInstance().font;
        }
        poseStack.drawString(this.font, text, x + this.guiLeft - this.leftPos, y + this.guiTop - this.topPos, color, false);
        return x;
    }

    public int drawString(GuiGraphics poseStack, int x, int y, String text, int color) {
        if (this.font == null) {
            this.font = Minecraft.getInstance().font;
        }
        poseStack.drawString(this.font, text, x + this.guiLeft - this.leftPos, y + this.guiTop - this.topPos, color, false);
        return x;
    }

    public int drawString(GuiGraphics poseStack, int x, int y, String text, int color, boolean shadow) {
        if (this.font == null) {
            this.font = Minecraft.getInstance().font;
        }
        poseStack.drawString(this.font, text, x + this.guiLeft - this.leftPos, y + this.guiTop - this.topPos, color, shadow);
        return x;
    }

    public void drawXCenteredString(GuiGraphics graphics, int n, int n2, Component component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXCenteredString(GuiGraphics graphics, int n, int n2, String component, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, component, n3, bl, true, false);
    }

    public void drawXYCenteredString(GuiGraphics graphics, int n, int n2, String string, int n3, boolean bl) {
        this.drawCenteredString(graphics, n, n2, string, n3, bl, true, true);
    }

    public void drawCenteredString(GuiGraphics graphics, int n, int n2, String string, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(string) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        graphics.drawString(this.font, string, this.getGuiLeft() + n, this.getGuiTop() + n2, n3, false);
    }

    public void drawCenteredString(GuiGraphics graphics, int n, int n2, Component component, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            n -= this.getStringWidth(component) / 2;
        }
        if (bl3) {
            n2 -= 4;
        }
        graphics.drawString(this.font, component.getString(), this.getGuiLeft() + n, this.getGuiTop() + n2, n3, false);
    }

    public int getStringWidth(String string) {
        return this.font.width(string);
    }

    public int getStringWidth(Component component) {
        return this.font.width((FormattedText)component);
    }

    public String trimStringToWidth(String string, int n) {
        return this.font.plainSubstrByWidth(string, n, false);
    }

    public String trimStringToWidthReverse(String string, int n) {
        return this.font.plainSubstrByWidth(string, n, true);
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (((ContainerBase)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            pGuiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, pX, pY);
        }
    }

    public void drawTooltip(GuiGraphics poseStack, int x, int y, ItemStack stack) {
        assert (!ModUtils.isEmpty(stack));
        poseStack.renderTooltip(this.font, stack, x, y);
    }

    public void drawTooltipOnlyName(GuiGraphics poseStack, int x, int y, ItemStack stack, List<String> strings) {
        if (stack.isEmpty()) {
            return;
        }
        ArrayList<Component> tooltipComponents = new ArrayList<Component>();
        tooltipComponents.add(stack.getDisplayName());
        strings.forEach(s -> tooltipComponents.add((Component)Component.literal((String)s)));
        poseStack.renderComponentTooltip(this.font, tooltipComponents, x, y);
    }

    public void drawTooltip(int n, int n2, List<String> list) {
        this.queuedTooltips.add(new Tooltip(list, n, n2));
    }

    protected void flushTooltips(GuiGraphics graphics) {
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>(this.queuedTooltips);
        ArrayList<Tooltip> tooltipsToRender = new ArrayList<Tooltip>();
        ArrayList<Rectangle> usedAreas = new ArrayList<Rectangle>();
        for (int i = tooltips.size() - 1; i >= 0; --i) {
            Tooltip tooltip = (Tooltip)tooltips.get(i);
            int maxWidth = 0;
            for (FormattedText formattedText : tooltip.text) {
                int lineWidth = Minecraft.getInstance().font.width(formattedText);
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int tooltipWidth = maxWidth + 8;
            int n = tooltip.text.size() * 10 + 8;
            Rectangle tooltipArea = new Rectangle(tooltip.x, tooltip.y, tooltipWidth, n);
            boolean overlaps = false;
            for (Rectangle area : usedAreas) {
                if (!tooltipArea.intersects(area)) continue;
                overlaps = true;
                break;
            }
            if (overlaps) continue;
            usedAreas.add(tooltipArea);
            tooltipsToRender.add(tooltip);
        }
        Collections.reverse(tooltipsToRender);
        for (Tooltip tooltip : tooltipsToRender) {
            graphics.renderTooltip(this.font, tooltip.text, Optional.empty(), tooltip.x, tooltip.y);
        }
        this.queuedTooltips.clear();
    }

    protected void addElement(GuiElement<?> guiElement) {
        this.elements.add(guiElement);
    }

    public final void bindTexture() {
        GuiCore.bindTexture(this.getTexture());
    }

    protected abstract ResourceLocation getTexture();

    public void drawTexturedModalRect(GuiGraphics poseStack, int i, int i1, int i2, int i3, int i4, int i5) {
        poseStack.blit(currentTexture, i, i1, i2, i3, i4, i5);
    }

    public void drawTextInCanvasWithScissor(GuiGraphics poseStack, String text, int canvasX, int canvasY, int canvasWidth, int canvasHeight, int scale) {
        int maxWidth = canvasWidth / 1;
        int lineHeight = 10;
        int x = canvasX;
        int y = canvasY;
        List<String> lines = this.splitTextToLines(text, maxWidth, 1.0f);
        for (int i = scale - 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (y + lineHeight > canvasY + canvasHeight) break;
            poseStack.pose().pushPose();
            poseStack.pose().scale(1.0f, 1.0f, 1.0f);
            this.drawString(poseStack, line, x / 1, y / 1, 0xFFFFFF);
            poseStack.pose().popPose();
            y += lineHeight;
        }
    }

    private static class Tooltip {
        final int x;
        final int y;
        final List<Component> text = new LinkedList<Component>();

        Tooltip(List<String> list, int n, int n2) {
            list.forEach(s -> this.text.add((Component)Component.literal((String)s)));
            this.x = n;
            this.y = n2;
        }
    }
}

