/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.ImageInterface;
import com.denfop.container.ContainerItemManipulator;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.mechanism.TileEntityItemManipulator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiItemManipulator<T extends ContainerItemManipulator>
extends GuiIU<ContainerItemManipulator> {
    public final ContainerItemManipulator container;

    public GuiItemManipulator(ContainerItemManipulator container1) {
        super(container1);
        this.container = container1;
        this.imageWidth = 220;
        this.imageHeight = 220;
        this.inventory.setX(7);
        this.inventory.setY(138);
        this.elements.add(new ImageInterface(this, 0, 0, this.imageWidth, this.imageHeight));
    }

    private static List<String> getInformation() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Localization.translate("iu.moduleinformation1"));
        ret.add(Localization.translate("iu.moduleinformation2"));
        ret.add(Localization.translate("iu.moduleinformation3"));
        return ret;
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        String name = Localization.translate(((TileEntityItemManipulator)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2, 4, name, 0x404040, false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        String name = Localization.translate(((TileEntityItemManipulator)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2, 4, name, 0x404040, false);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.moduleinformation"));
            List<String> compatibleUpgrades = GuiItemManipulator.getInformation();
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine_main1.png");
    }
}

