/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.container.ContainerMiniPanels;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiCore;
import com.denfop.tiles.panels.entity.TileEntityMiniPanels;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiMiniPanel<T extends ContainerMiniPanels>
extends GuiCore<ContainerMiniPanels> {
    private final TileEntityMiniPanels tileentity;

    public GuiMiniPanel(ContainerMiniPanels guiContainer) {
        super(guiContainer);
        this.tileentity = ((ContainerMiniPanels)this.container).getTileEntity();
        this.imageWidth = 202;
        this.imageHeight = 232;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        int nmPos = (this.imageWidth - this.getStringWidth(Localization.translate(this.tileentity.getName()))) / 2;
        this.draw(poseStack, Localization.translate(this.tileentity.getName()), nmPos, 6, 7718655);
        String storageString = Localization.translate("gui.SuperSolarPanel.storage") + ": ";
        String maxOutputString = Localization.translate("gui.SuperSolarPanel.maxOutput") + ": ";
        String generatingString = Localization.translate("gui.SuperSolarPanel.generating") + ": ";
        String energyPerTickString = Localization.translate("gui.SuperSolarPanel.energyPerTick");
        String Time1 = Localization.translate("iu.time");
        String Time4 = Localization.translate("iu.time1");
        String Time5 = Localization.translate("iu.time2");
        String Time6 = Localization.translate("iu.time3");
        String Time7 = Localization.translate("iu.time4");
        String maxstorage_1 = ModUtils.getString(this.tileentity.component.getCapacity());
        String maxstorage_2 = ModUtils.getString(this.tileentity.component.getStorage());
        String generation = ModUtils.getString(this.tileentity.generating);
        String tooltip2 = generatingString + generation + " " + energyPerTickString;
        String tooltip = storageString + maxstorage_2 + "/" + maxstorage_1;
        this.draw(poseStack, maxOutputString, 5, 120, 0xCDCDCD);
        this.draw(poseStack, ModUtils.getString(this.tileentity.component.getProdution()) + " EF", 25 - this.getStringWidth(ModUtils.getString(this.tileentity.component.getProdution())), 129, 0xCDCDCD);
        this.draw(poseStack, Localization.translate("iu.wind_tier"), 167, 120, 0xCDCDCD);
        this.draw(poseStack, ModUtils.getString(this.tileentity.getCoreLevel()), 180, 129, 0xCDCDCD);
        Object temptime = Localization.translate("pollutionpnale");
        switch (this.tileentity.timer.getIndexWork()) {
            case 0: {
                temptime = Time1 + this.tileentity.timer.getTime() + "\n" + Time4;
                break;
            }
            case 1: {
                temptime = Time1 + this.tileentity.timer.getTime() + "\n" + Time5;
                break;
            }
            case 2: {
                temptime = Time1 + this.tileentity.timer.getTime() + "\n" + Time6;
                break;
            }
            case -1: {
                temptime = Time7;
            }
        }
        ((Area)new AdvArea(this, 168, 19, 183, 111).withTooltip((String)temptime)).drawForeground(poseStack, mouseX, mouseY);
        ((Area)new AdvArea(this, 96, 135, 105, 143).withTooltip(tooltip2)).drawForeground(poseStack, mouseX, mouseY);
        ((Area)new AdvArea(this, 80, 111, 122, 132).withTooltip(tooltip)).drawForeground(poseStack, mouseX, mouseY);
        if (!this.tileentity.invSlotGlass.isEmpty()) {
            ((Area)new AdvArea(this, 18, 19, 32, 111).withTooltip(Localization.translate("iu.minipanel.stable_place") + Math.max(0, 100 - (int)this.tileentity.load) + " %")).drawForeground(poseStack, mouseX, mouseY);
        }
        if (this.tileentity.component.getBonusCapacity() != 0.0) {
            ((Area)new Area(this, 184, 20, 16, 16).withTooltip(Localization.translate("iu.minipanel.bonus") + (int)(this.tileentity.component.getBonusCapacity() * 100.0) + " %")).drawForeground(poseStack, mouseX, mouseY);
        }
        if (this.tileentity.component.getBonusProdution() != 0.0) {
            ((Area)new Area(this, 184, 40, 16, 16).withTooltip(Localization.translate("iu.minipanel.bonus") + (int)(this.tileentity.component.getBonusProdution() * 100.0) + " %")).drawForeground(poseStack, mouseX, mouseY);
        }
        if (this.tileentity.bonusGeneration != 0.0) {
            ((Area)new Area(this, 184, 60, 16, 16).withTooltip(Localization.translate("iu.minipanel.bonus") + (int)(this.tileentity.bonusGeneration * 100.0) + " %")).drawForeground(poseStack, mouseX, mouseY);
        }
        if (this.tileentity.pollution.isActive()) {
            new ItemStackImage(this, 184, 93, this.tileentity.pollution::getStack).drawForeground(poseStack, mouseX, mouseY);
        }
        for (int i = 0; i < this.tileentity.invSlotGlass.size(); ++i) {
            TileEntityMiniPanels.EnumState second;
            TileEntityMiniPanels.EnumState first;
            List<TileEntityMiniPanels.EnumState> list = this.tileentity.listStable.get(i);
            if (list.size() == 0) continue;
            if (i == 0) {
                first = list.get(0);
                ((Area)new Area(this, 87, 34, 8, 8).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
                second = list.get(1);
                ((Area)new Area(this, 74, 51, 9, 6).withTooltip(Localization.translate("iu.minipanel." + second.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 1) {
                first = list.get(0);
                ((Area)new Area(this, 110, 38, 6, 9).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
                second = list.get(1);
                ((Area)new Area(this, 97, 51, 9, 6).withTooltip(Localization.translate("iu.minipanel." + second.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 2) {
                first = list.get(0);
                ((Area)new Area(this, 120, 51, 9, 6).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 3) {
                first = list.get(0);
                ((Area)new Area(this, 87, 61, 6, 9).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
                second = list.get(1);
                ((Area)new Area(this, 74, 74, 9, 6).withTooltip(Localization.translate("iu.minipanel." + second.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 4) {
                first = list.get(0);
                ((Area)new Area(this, 110, 61, 6, 9).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
                second = list.get(1);
                ((Area)new Area(this, 97, 74, 9, 6).withTooltip(Localization.translate("iu.minipanel." + second.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 5) {
                first = list.get(0);
                ((Area)new Area(this, 120, 74, 9, 6).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i == 6) {
                first = list.get(0);
                ((Area)new Area(this, 87, 84, 6, 9).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
            }
            if (i != 7) continue;
            first = list.get(0);
            ((Area)new Area(this, 110, 84, 6, 9).withTooltip(Localization.translate("iu.minipanel." + first.name().toLowerCase()))).drawForeground(poseStack, mouseX, mouseY);
        }
    }

    private void DrawModel(GuiGraphics poseStack, int h, int k) {
        if (!this.tileentity.rain) {
            if (this.tileentity.sunIsUp) {
                this.drawTexturedModalRect(poseStack, h + 96, k + 134, 213, 97, 10, 10);
            } else {
                this.drawTexturedModalRect(poseStack, h + 96, k + 134, 223, 97, 10, 10);
            }
        } else if (this.tileentity.sunIsUp) {
            this.drawTexturedModalRect(poseStack, h + 96, k + 134, 234, 97, 10, 10);
        } else {
            this.drawTexturedModalRect(poseStack, h + 96, k + 134, 244, 97, 10, 10);
        }
    }

    @Override
    protected void renderBg(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        int pollution;
        int stable_level;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiMiniPanel.bindTexture(this.getTexture());
        int h = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, h, k, 0, 0, this.imageWidth, 147);
        this.drawTexturedModalRect(poseStack, h, k + 147, 0, 147, 190, this.imageHeight - 146);
        if (this.tileentity.skyIsVisible) {
            this.DrawModel(poseStack, h, k);
        }
        if (this.tileentity.component.getEnergy() > 0.0) {
            double l = Math.min(1.0, this.tileentity.component.getFillRatio()) * 37.0;
            this.drawTexturedModalRect(poseStack, h + 83, k + 114, 214, 112, (int)l, 15);
        }
        if ((stable_level = (int)Math.min(85.0 * ((TileEntityMiniPanels)((ContainerMiniPanels)this.container).base).load / 100.0, 85.0)) > 0) {
            this.drawTexturedModalRect(poseStack, h + 22, k + 23 + 85 - stable_level, 217, 91 - stable_level, 7, stable_level);
        }
        if ((pollution = (int)Math.min((double)(85 * (((TileEntityMiniPanels)((ContainerMiniPanels)this.container).base).pollution.getAllTime() - ((TileEntityMiniPanels)((ContainerMiniPanels)this.container).base).pollution.getTime())) / ((double)((TileEntityMiniPanels)((ContainerMiniPanels)this.container).base).pollution.getAllTime() * 1.0), 85.0)) > 0) {
            this.drawTexturedModalRect(poseStack, h + 173, k + 23 + 85 - pollution, 234, 91 - pollution, 7, pollution);
        }
        for (int i = 0; i < this.tileentity.invSlotGlass.size(); ++i) {
            TileEntityMiniPanels.EnumState second;
            TileEntityMiniPanels.EnumState first;
            List<TileEntityMiniPanels.EnumState> list = this.tileentity.listStable.get(i);
            if (list.size() == 0) continue;
            if (i == 0) {
                first = list.get(1);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 51, 220, 135, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 51, 220, 144, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 51, 220, 153, 9, 6);
                }
                second = list.get(0);
                if (second == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 38, 213, 135, 6, 9);
                } else if (second == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 38, 213, 144, 6, 9);
                } else if (second == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 38, 213, 153, 6, 9);
                }
            }
            if (i == 1) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 38, 213, 135, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 38, 213, 144, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 38, 213, 153, 6, 9);
                }
                second = list.get(1);
                if (second == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 51, 220, 135, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 51, 220, 144, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 51, 220, 153, 9, 6);
                }
            }
            if (i == 2) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 51, 220, 135, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 51, 220, 144, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 51, 220, 153, 9, 6);
                }
            }
            if (i == 3) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 61, 213, 135, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 61, 213, 144, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 61, 213, 153, 6, 9);
                }
                second = list.get(1);
                if (second == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 74, 220, 135, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 74, 220, 144, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 74, k + 74, 220, 153, 9, 6);
                }
            }
            if (i == 4) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 61, 213, 135, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 61, 213, 144, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 110, k + 61, 213, 153, 6, 9);
                }
                second = list.get(1);
                if (second == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 74, 220, 135, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 74, 220, 144, 9, 6);
                } else if (second == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 97, k + 74, 220, 153, 9, 6);
                }
            }
            if (i == 5) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 74, 220, 135, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 74, 220, 144, 9, 6);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 120, k + 74, 220, 153, 9, 6);
                }
            }
            if (i == 6) {
                first = list.get(0);
                if (first == TileEntityMiniPanels.EnumState.STABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 84, 213, 135, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 84, 213, 144, 6, 9);
                } else if (first == TileEntityMiniPanels.EnumState.UNSTABLE) {
                    this.drawTexturedModalRect(poseStack, h + 87, k + 84, 213, 153, 6, 9);
                }
            }
            if (i != 7) continue;
            first = list.get(0);
            if (first == TileEntityMiniPanels.EnumState.STABLE) {
                this.drawTexturedModalRect(poseStack, h + 110, k + 84, 213, 135, 6, 9);
                continue;
            }
            if (first == TileEntityMiniPanels.EnumState.NORMAL) {
                this.drawTexturedModalRect(poseStack, h + 110, k + 84, 213, 144, 6, 9);
                continue;
            }
            if (first != TileEntityMiniPanels.EnumState.UNSTABLE) continue;
            this.drawTexturedModalRect(poseStack, h + 110, k + 84, 213, 153, 6, 9);
        }
        if (this.tileentity.pollution.isActive()) {
            new ItemStackImage(this, 184, 93, this.tileentity.pollution::getStack).drawBackground(poseStack, h, k);
        }
        this.bindTexture();
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(0.75f, 0.75f, 0.75f);
        this.drawTexturedModalRect(poseStack, (int)((float)(h + 25) / 0.75f), (int)((float)(k + 105) / 0.75f), 237, 134, 16, 16);
        this.drawTexturedModalRect(poseStack, (int)((float)(h + 179) / 0.75f), (int)((float)(k + 105) / 0.75f), 237, 151, 16, 16);
        pose.popPose();
        if (this.tileentity.component.getBonusCapacity() > 0.0) {
            new ItemStackImage(this, 184, 20, () -> this.tileentity.invSlotStorage.get(0)).drawBackground(poseStack, h, k);
            pose.pushPose();
            pose.scale(0.15f, 0.15f, 1.0f);
            GuiMiniPanel.bindTexture(this.getTexture());
            RenderSystem.disableDepthTest();
            this.drawTexturedModalRect(poseStack, (int)((float)(h + 193) / 0.15f), (int)((float)(k + 28) / 0.15f), 192, 199, 58, 56);
            RenderSystem.enableDepthTest();
            pose.popPose();
        }
        if (this.tileentity.component.getBonusProdution() > 0.0) {
            new ItemStackImage(this, 184, 40, () -> this.tileentity.invSlotOutput.get(0)).drawBackground(poseStack, h, k);
            pose.pushPose();
            pose.scale(0.15f, 0.15f, 1.0f);
            GuiMiniPanel.bindTexture(this.getTexture());
            RenderSystem.disableDepthTest();
            this.drawTexturedModalRect(poseStack, (int)((float)(h + 193) / 0.15f), (int)((float)(k + 46) / 0.15f), 192, 199, 58, 56);
            RenderSystem.enableDepthTest();
            pose.popPose();
        }
        if (this.tileentity.bonusGeneration > 0.0) {
            new ItemStackImage(this, 184, 60, () -> this.tileentity.invSlotGlass.get(0)).drawBackground(poseStack, h, k);
            pose.pushPose();
            pose.scale(0.15f, 0.15f, 1.0f);
            GuiMiniPanel.bindTexture(this.getTexture());
            RenderSystem.disableDepthTest();
            this.drawTexturedModalRect(poseStack, (int)((float)(h + 193) / 0.15f), (int)((float)(k + 66) / 0.15f), 192, 199, 58, 56);
            RenderSystem.enableDepthTest();
            pose.popPose();
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_mini_panels.png");
    }
}

