/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentEmpty;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerSteamAmpereGenerator;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.mechanism.steam.TileEntitySteamAmpereGenerator;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.IFluidTank;

public class GuiSteamAmpereGenerator<T extends ContainerSteamAmpereGenerator>
extends GuiIU<ContainerSteamAmpereGenerator> {
    public ContainerSteamAmpereGenerator container;
    public String name;

    public GuiSteamAmpereGenerator(ContainerSteamAmpereGenerator guiContainer) {
        super(guiContainer, EnumTypeStyle.STEAM);
        this.container = guiContainer;
        this.name = Localization.translate(((TileEntitySteamAmpereGenerator)guiContainer.base).getName());
        this.componentList.add(new GuiComponent(this, 70, 41, EnumTypeComponent.STEAM_PROCESS, new Component<ComponentEmpty>(new ComponentEmpty())));
        this.addElement(TankGauge.createNormal(this, 42, 22, (IFluidTank)((TileEntitySteamAmpereGenerator)this.container.base).fluidTank));
        this.addComponent(new GuiComponent(this, 95, 39, EnumTypeComponent.STEAM_ENERGY_HEIGHT, new Component<ComponentBaseEnergy>(((TileEntitySteamAmpereGenerator)this.container.base).pressure)));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("steam_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 11; ++i) {
                compatibleUpgrades.add(Localization.translate("steam_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSteamAmpereGenerator.bindTexture(this.getTexture());
        GuiSteamAmpereGenerator.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guisteam_machine.png");
    }
}

