/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.gui.ItemStackImageText;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.gui.TankGauge;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerTesseract;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.recipes.BaseRecipes;
import com.denfop.tiles.base.TileEntityTesseract;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class GuiTesseract<T extends ContainerTesseract>
extends GuiIU<ContainerTesseract> {
    private final ItemStack stack;
    private final TankGauge fluid;
    boolean hoverShowPublicChannels;
    boolean hoverShowInventory;
    boolean hoverShowOwnChannels;
    boolean hoverShowCreateChannels;
    double scrollPositionChannels;
    double posScrollPositionChannels;
    boolean hoverUpChannel;
    boolean hoverDownChannel;
    boolean hoverEnergyChannel;
    boolean hoverFluidChannel;
    boolean hoverItemChannel;
    boolean hoverExtractChannel;
    boolean hoverReceiveChannel;
    boolean hoverPublicChannel;
    boolean hoverDeleteChannel;
    boolean hoverChangeModeChannel;
    boolean hoverBack;
    int indexTesseract = 0;
    int indexMaxTesseract = 1;
    int indexPublicTesseract = 0;
    int indexPublicMaxTesseract = 1;
    int prevId = -1;
    private int guiScreenID = 0;
    private int index = 24;
    private int index1 = 24;

    public GuiTesseract(ContainerTesseract guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.stack = BaseRecipes.getBlockStack(BlockBaseMachine3.tesseract);
        this.fluid = new TankGauge(this, 147, 10, 16, 53, (IFluidTank)((TileEntityTesseract)((ContainerTesseract)this.container).base).getTank(), TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((TileEntityTesseract)((ContainerTesseract)GuiTesseract.this.container).base).getTank().getFluid();
                if (Keyboard.isKeyDown(340)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = ((TileEntityTesseract)((ContainerTesseract)GuiTesseract.this.container).base).getTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 9;
                        fluidHeight = 46;
                    }
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + 97, this.gui.guiTop + 14, 191, 5, 7, 46);
                }
            }
        };
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.tesseract.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 8; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.tesseract.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getDisplayName().getString();
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 6) / scale);
        if (this.guiScreenID == 0) {
            poseStack.drawString(Minecraft.getInstance().font, name, textX, textY, 0x404040, false);
        }
        pose.scale(1.0f / scale, 1.0f / scale, 1.0f);
        pose.popPose();
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d4, double d3) {
        double temp;
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (this.guiScreenID == 2 && mouseX >= 20 && mouseY >= 17 && mouseX <= 155 && mouseY <= 69) {
            if (scrollDirection == ScrollDirection.down) {
                ++this.indexTesseract;
                this.indexMaxTesseract = this.indexTesseract * 7 + 21;
                this.indexMaxTesseract = Math.min(this.indexMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size());
                temp = (double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size() / 7.0;
                if ((double)this.indexTesseract >= (temp -= 2.0)) {
                    --this.indexTesseract;
                }
                if (this.indexTesseract < 0) {
                    this.indexTesseract = 0;
                }
            }
            if (scrollDirection == ScrollDirection.up) {
                --this.indexTesseract;
                if (this.indexTesseract < 0) {
                    this.indexTesseract = 0;
                }
                this.indexMaxTesseract = this.indexTesseract * 7 + 21;
                this.indexMaxTesseract = Math.min(this.indexMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size());
            }
        }
        if (this.guiScreenID == 4 && mouseX >= 20 && mouseY >= 17 && mouseX <= 155 && mouseY <= 69) {
            if (scrollDirection == ScrollDirection.down) {
                ++this.indexPublicTesseract;
                this.indexPublicMaxTesseract = this.indexPublicTesseract * 7 + 21;
                this.indexPublicMaxTesseract = Math.min(this.indexPublicMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size());
                temp = (double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size() / 7.0;
                if ((double)this.indexPublicTesseract >= (temp -= 2.0)) {
                    --this.indexPublicTesseract;
                }
                if (this.indexPublicTesseract < 0) {
                    this.indexPublicTesseract = 0;
                }
            }
            if (scrollDirection == ScrollDirection.up) {
                --this.indexPublicTesseract;
                if (this.indexPublicTesseract < 0) {
                    this.indexPublicTesseract = 0;
                }
                this.indexPublicMaxTesseract = this.indexPublicTesseract * 7 + 21;
                this.indexPublicMaxTesseract = Math.min(this.indexPublicMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size());
            }
        }
        return super.mouseScrolled(d, d2, d4, d3);
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        if (this.guiScreenID == 0) {
            this.handleUpgradeTooltip(par1, par2);
        }
        switch (this.guiScreenID) {
            case 0: {
                this.hoverShowPublicChannels = false;
                this.hoverShowInventory = false;
                this.hoverShowOwnChannels = false;
                this.hoverShowCreateChannels = false;
                if (par1 >= 31 && par1 <= 54 && par2 >= 31 && par2 <= 54) {
                    this.hoverShowCreateChannels = true;
                }
                if (par1 >= 61 && par1 <= 84 && par2 >= 31 && par2 <= 54) {
                    this.hoverShowOwnChannels = true;
                }
                if (par1 >= 91 && par1 <= 114 && par2 >= 31 && par2 <= 54) {
                    this.hoverShowPublicChannels = true;
                }
                if (par1 >= 121 && par1 <= 164 && par2 >= 31 && par2 <= 54) {
                    this.hoverShowInventory = true;
                }
                if (this.hoverShowCreateChannels) {
                    ((Area)new AdvArea(this, 31, 31, 54, 54).withTooltip(Localization.translate("tesseract.create_channel"))).drawForeground(poseStack, par1, par2);
                }
                if (this.hoverShowPublicChannels) {
                    ((Area)new AdvArea(this, 91, 31, 124, 54).withTooltip(Localization.translate("tesseract.public_channel"))).drawForeground(poseStack, par1, par2);
                }
                if (this.hoverShowInventory) {
                    ((Area)new AdvArea(this, 121, 31, 164, 54).withTooltip(Localization.translate("tesseract.inventory"))).drawForeground(poseStack, par1, par2);
                }
                if (!this.hoverShowOwnChannels) break;
                ((Area)new AdvArea(this, 61, 31, 84, 54).withTooltip(Localization.translate("tesseract.lists"))).drawForeground(poseStack, par1, par2);
                break;
            }
            case 1: {
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel == null) {
                    return;
                }
                this.hoverUpChannel = false;
                this.hoverDownChannel = false;
                this.hoverEnergyChannel = false;
                this.hoverFluidChannel = false;
                this.hoverItemChannel = false;
                this.hoverExtractChannel = false;
                this.hoverReceiveChannel = false;
                this.hoverPublicChannel = false;
                this.hoverDeleteChannel = false;
                this.hoverChangeModeChannel = false;
                this.hoverBack = false;
                if (par1 >= 56 && par2 >= 7 && par1 <= 75 && par2 <= 27) {
                    this.hoverEnergyChannel = true;
                    ((Area)new Area(this, 56, 7, 19, 20).withTooltip(Localization.translate("tesseract.energy"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 78 && par2 >= 7 && par1 <= 97 && par2 <= 27) {
                    this.hoverFluidChannel = true;
                    ((Area)new Area(this, 78, 7, 19, 20).withTooltip(Localization.translate("tesseract.fluid"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 100 && par2 >= 7 && par1 <= 119 && par2 <= 27) {
                    this.hoverItemChannel = true;
                    ((Area)new Area(this, 100, 7, 19, 20).withTooltip(Localization.translate("tesseract.item"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 7 && par2 >= 55 && par1 <= 21 && par2 <= 65) {
                    this.hoverUpChannel = true;
                    ((Area)new Area(this, 7, 55, 14, 10).withTooltip(Localization.translate("tesseract.plus"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 7 && par2 >= 67 && par1 <= 21 && par2 <= 77) {
                    this.hoverDownChannel = true;
                    ((Area)new Area(this, 7, 67, 14, 10).withTooltip(Localization.translate("tesseract.minus"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 67 && par2 >= 57 && par1 <= 86 && par2 <= 77) {
                    this.hoverReceiveChannel = true;
                    ((Area)new Area(this, 67, 57, 19, 20).withTooltip(Localization.translate("tesseract.sink"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 89 && par2 >= 57 && par1 <= 108 && par2 <= 77) {
                    this.hoverExtractChannel = true;
                    ((Area)new Area(this, 89, 57, 19, 20).withTooltip(Localization.translate("tesseract.source"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 149 && par2 >= 34 && par1 <= 168 && par2 <= 54) {
                    this.hoverPublicChannel = true;
                    ((Area)new Area(this, 149, 34, 19, 20).withTooltip(Localization.translate("tesseract.player_channel") + "- " + ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTesseract().getPlayer() + "\n" + Localization.translate("tesseract.private") + (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.isPrivate() ? Localization.translate("iu.yes") : Localization.translate("iu.no")))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 65 && par2 >= 35 && par1 <= 110 && par2 <= 50) {
                    this.hoverChangeModeChannel = true;
                    ((Area)new AdvArea(this, 65, 35, 110, 50).withTooltip(Localization.translate("tesseract.activate"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 149 && par2 >= 57 && par1 <= 168 && par2 <= 77) {
                    this.hoverDeleteChannel = true;
                    ((Area)new Area(this, 149, 57, 19, 20).withTooltip(Localization.translate("tesseract.delete"))).drawForeground(poseStack, par1, par2);
                }
                if (par1 < 5 || par2 < 5 || par1 > 13 || par2 > 16) break;
                this.hoverBack = true;
                break;
            }
            case 2: {
                this.hoverBack = false;
                this.indexMaxTesseract = this.indexTesseract * 7 + 21;
                this.indexMaxTesseract = Math.min(this.indexMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size());
                if ((double)this.indexTesseract > Math.floor((double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size() / 7.0) - 2.0) {
                    --this.indexTesseract;
                }
                if (this.indexTesseract < 0) {
                    this.indexTesseract = 0;
                }
                int j = 0;
                int i = this.indexTesseract * 7;
                while (i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.indexMaxTesseract)) {
                    Channel channel = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannel(i);
                    new ItemStackImageText(this, 22 + j % 7 * 17, 19 + j / 7 * 17, () -> this.stack, Localization.translate("tesseract.channel") + channel.getChannel() + "\n" + Localization.translate("tesseract.private") + (channel.isPrivate() ? Localization.translate("iu.yes") : Localization.translate("iu.no")) + "\n" + Localization.translate("tesseract.player") + channel.getTesseract().getPlayer() + "\n" + Localization.translate("tesseract.type_channel") + channel.getTypeChannel().name() + "\n" + Localization.translate("tesseract.mode") + channel.getMode().name() + "\n" + Localization.translate("tesseract.private") + (channel.isActive() ? Localization.translate("iu.yes") : Localization.translate("iu.no")) + "\n").drawForeground(poseStack, par1, par2);
                    ++i;
                    ++j;
                }
                if (par1 < 5 || par2 < 5 || par1 > 13 || par2 > 16) break;
                this.hoverBack = true;
                break;
            }
            case 3: {
                this.hoverBack = false;
                this.fluid.drawForeground(poseStack, par1, par2);
                List<ItemStack> itemStackList = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getSlotItem().stream().filter(itemStack -> !itemStack.isEmpty()).toList();
                for (int i = 0; i < itemStackList.size(); ++i) {
                    int finalI = i;
                    ((Area)new Area(this, 35 + i % 6 * 20, 11 + i / 6 * 22, 18, 18).withTooltip((Supplier<String>)((Supplier)() -> ((ItemStack)itemStackList.get(finalI)).getDisplayName().getString()))).drawForeground(poseStack, par1, par2);
                }
                if (par1 >= 5 && par2 >= 5 && par1 <= 13 && par2 <= 16) {
                    this.hoverBack = true;
                }
                ((Area)new AdvArea(this, 7, 68, 168, 79).withTooltip(ModUtils.getString(Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getEnergy().getEnergy(), ((TileEntityTesseract)((ContainerTesseract)this.container).base).getEnergy().getCapacity())) + "/" + ModUtils.getString(((TileEntityTesseract)((ContainerTesseract)this.container).base).getEnergy().getCapacity()) + " EF")).drawForeground(poseStack, par1, par2);
                break;
            }
            case 4: {
                this.hoverBack = false;
                this.indexPublicMaxTesseract = this.indexPublicTesseract * 7 + 21;
                this.indexPublicMaxTesseract = Math.min(this.indexPublicMaxTesseract, ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size());
                if ((double)this.indexPublicTesseract > Math.floor((double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size() / 7.0) - 2.0) {
                    --this.indexPublicTesseract;
                }
                if (this.indexPublicTesseract < 0) {
                    this.indexPublicTesseract = 0;
                }
                int j = 0;
                int i = this.indexPublicTesseract * 7;
                while (i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size(), this.indexPublicMaxTesseract)) {
                    Channel channel = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().get(i);
                    new ItemStackImageText(this, 22 + j % 7 * 17, 19 + j / 7 * 17, () -> this.stack, Localization.translate("tesseract.channel") + channel.getChannel() + "\n" + Localization.translate("tesseract.private") + (channel.isPrivate() ? Localization.translate("iu.yes") : Localization.translate("iu.no")) + "\n" + Localization.translate("tesseract.player") + channel.getTesseract().getPlayer() + "\n" + Localization.translate("tesseract.type_channel") + channel.getTypeChannel().name() + "\n" + Localization.translate("tesseract.mode") + channel.getMode().name() + "\n" + Localization.translate("tesseract.private") + (channel.isActive() ? Localization.translate("iu.yes") : Localization.translate("iu.no")) + "\n").drawForeground(poseStack, par1, par2);
                    ++i;
                    ++j;
                }
                if (par1 < 5 || par2 < 5 || par1 > 13 || par2 > 16) break;
                this.hoverBack = true;
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        switch (this.guiScreenID) {
            case 0: {
                if (this.hoverShowCreateChannels) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 31, this.guiTop + 31, 232, 0, 24, 25);
                }
                if (this.hoverShowInventory) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 121, this.guiTop + 31, 232, 0, 24, 25);
                }
                if (this.hoverShowPublicChannels) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 91, this.guiTop + 31, 232, 0, 24, 25);
                }
                if (!this.hoverShowOwnChannels) break;
                this.drawTexturedModalRect(poseStack, this.guiLeft + 61, this.guiTop + 31, 232, 0, 24, 25);
                break;
            }
            case 1: {
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel == null) {
                    return;
                }
                this.drawXCenteredString(poseStack, 38, 64, String.valueOf(((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getChannel()), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.bindTexture();
                if (this.hoverReceiveChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 67, this.guiTop + 57, 236, 81, 20, 21);
                }
                if (this.hoverExtractChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 89, this.guiTop + 57, 236, 81, 20, 21);
                }
                if (this.hoverEnergyChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 56, this.guiTop + 7, 236, 81, 20, 21);
                }
                if (this.hoverFluidChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 78, this.guiTop + 7, 236, 81, 20, 21);
                }
                if (this.hoverItemChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 100, this.guiTop + 7, 236, 81, 20, 21);
                }
                if (this.hoverDeleteChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 149, this.guiTop + 57, 236, 81, 20, 21);
                }
                if (this.hoverUpChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 7, this.guiTop + 55, 241, 103, 15, 12);
                }
                if (this.hoverDownChannel) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 7, this.guiTop + 67, 241, 103, 15, 12);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INOUT || ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INPUT) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 67, this.guiTop + 57, 215, 22, 19, 20);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INOUT || ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.OUTPUT) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 89, this.guiTop + 57, 236, 22, 19, 20);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.ENERGY) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 56, this.guiTop + 7, 194, 0, 19, 20);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.FLUID) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 78, this.guiTop + 7, 215, 0, 19, 20);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.ITEM) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 100, this.guiTop + 7, 236, 0, 19, 20);
                }
                if (this.hoverBack) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 6, this.guiTop + 6, 249, 130, 7, 10);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.isPrivate()) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 149, this.guiTop + 33, 236, 58, 19, 20);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.isActive()) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 66 + 22, this.guiTop + 36, 234, 44, 22, 14);
                    if (this.hoverChangeModeChannel) {
                        this.drawTexturedModalRect(poseStack, this.guiLeft + 66 + 22, this.guiTop + 36, 234, 115, 22, 14);
                    }
                } else {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 66, this.guiTop + 36, 211, 44, 22, 14);
                    if (this.hoverChangeModeChannel) {
                        this.drawTexturedModalRect(poseStack, this.guiLeft + 66, this.guiTop + 36, 234, 115, 22, 14);
                    }
                }
                if (!this.hoverPublicChannel) break;
                this.drawTexturedModalRect(poseStack, this.guiLeft + 149, this.guiTop + 33, 236, 81, 20, 21);
                break;
            }
            case 2: {
                this.bindTexture();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(poseStack, this.guiLeft + 145, (int)((double)(this.guiTop + 18) + 32.0 * ((double)this.indexTesseract / (Math.floor((double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size() / 7.0) - 2.0))), 246, 0, 10, 19);
                int j = 0;
                int i = this.indexTesseract * 7;
                while (i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.indexMaxTesseract)) {
                    new ItemImage(this, 22 + j % 7 * 17, 19 + j / 7 * 17, (Supplier<ItemStack>)((Supplier)() -> this.stack)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                    ++i;
                    ++j;
                }
                if (!this.hoverBack) break;
                this.drawTexturedModalRect(poseStack, this.guiLeft + 6, this.guiTop + 6, 249, 130, 7, 10);
                break;
            }
            case 3: {
                this.fluid.drawBackground(poseStack, this.guiLeft, this.guiTop);
                if (this.hoverBack) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 6, this.guiTop + 6, 249, 130, 7, 10);
                }
                this.drawTexturedModalRect(poseStack, this.guiLeft + 56, this.guiTop + 7, 236, 81, 20, 21);
                this.drawTexturedModalRect(poseStack, this.guiLeft + 10, this.guiTop + 71, 10, 172, (int)(156.0 * ((TileEntityTesseract)((ContainerTesseract)this.container).base).getEnergy().getFillRatio()), 8);
                List itemStackList = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getSlotItem().stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
                for (int i = 0; i < itemStackList.size(); ++i) {
                    this.drawItemStack(poseStack, 35 + i % 6 * 20, 11 + i / 6 * 22, (ItemStack)itemStackList.get(i));
                }
                break;
            }
            case 4: {
                this.bindTexture();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(poseStack, this.guiLeft + 145, (int)((double)(this.guiTop + 18) + 32.0 * ((double)this.indexPublicTesseract / (Math.floor((double)((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size() / 7.0) - 2.0))), 246, 0, 10, 19);
                int j = 0;
                int i = this.indexPublicTesseract * 7;
                while (i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size(), this.indexPublicMaxTesseract)) {
                    new ItemImage(this, 22 + j % 7 * 17, 19 + j / 7 * 17, (Supplier<ItemStack>)((Supplier)() -> this.stack)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                    ++i;
                    ++j;
                }
                if (!this.hoverBack) break;
                this.drawTexturedModalRect(poseStack, this.guiLeft + 6, this.guiTop + 6, 249, 130, 7, 10);
            }
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        switch (this.guiScreenID) {
            case 0: {
                if (this.hoverShowCreateChannels) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 1.0);
                    this.guiScreenID = 1;
                    this.prevId = 0;
                }
                if (this.hoverShowOwnChannels) {
                    this.guiScreenID = 2;
                    this.prevId = 0;
                }
                if (this.hoverShowInventory) {
                    this.guiScreenID = 3;
                    this.prevId = 0;
                }
                if (!this.hoverShowPublicChannels) break;
                this.guiScreenID = 4;
                this.prevId = 0;
                break;
            }
            case 1: {
                if (this.hoverBack) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                    if (this.prevId != 0) {
                        this.guiScreenID = this.prevId;
                        this.prevId = 1;
                    } else {
                        this.guiScreenID = 0;
                        this.prevId = 1;
                    }
                }
                if (this.hoverUpChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 2.0);
                }
                if (this.hoverDownChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 3.0);
                }
                if (this.hoverDeleteChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 9.0);
                    this.guiScreenID = 0;
                }
                if (this.hoverReceiveChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 4.0);
                }
                if (this.hoverExtractChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 4.1);
                }
                if (this.hoverEnergyChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.0);
                }
                if (this.hoverFluidChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.1);
                }
                if (this.hoverItemChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.2);
                }
                if (this.hoverPublicChannel) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 6.0);
                }
                if (!this.hoverChangeModeChannel) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 7.0);
                break;
            }
            case 2: {
                int jj = 0;
                int ii = this.indexTesseract * 7;
                while (ii < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.indexMaxTesseract)) {
                    int x1 = 22 + jj % 7 * 17;
                    int y1 = 19 + jj / 7 * 17;
                    if (x >= x1 && x < x1 + 17 && y >= y1 && y < y1 + 17) {
                        double index2 = ii;
                        int del = 0;
                        while (index2 >= 1.0) {
                            index2 /= 10.0;
                            ++del;
                        }
                        new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 10.0 + (double)del / 10.0 + index2 / 10.0);
                        this.guiScreenID = 1;
                        this.prevId = 2;
                        break;
                    }
                    ++ii;
                    ++jj;
                }
                if (x < 9 || x > 27 || y < 8 || y > 20) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                this.prevId = 2;
                this.guiScreenID = 0;
                break;
            }
            case 3: {
                if (x < 9 || x > 27 || y < 8 || y > 20) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                this.guiScreenID = 0;
                break;
            }
            case 4: {
                if (x >= 9 && x <= 27 && y >= 8 && y <= 20) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                    this.guiScreenID = 0;
                }
                if (this.index1 < ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size() && x >= 156 && y >= 97 && x <= 173 && y <= 109) {
                    this.index1 += 24;
                }
                if (this.index1 - 24 <= 0 || x < 15 || y < 97 || x > 32 || y > 109) break;
                this.index1 -= 24;
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        switch (this.guiScreenID) {
            default: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guitesseract.png");
            }
            case 1: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guitesseract_create_channel.png");
            }
            case 3: {
                return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guitesseract_inventory.png");
            }
            case 2: 
            case 4: 
        }
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guitesseract_public_channels.png");
    }
}

