/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.api.gui.Area;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.container.ContainerVeinSensor;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.gui.GuiIU;
import com.denfop.items.DataOres;
import com.denfop.items.ItemStackVeinSensor;
import com.denfop.network.packet.PacketItemStackEvent;
import com.denfop.utils.Vector2;
import com.denfop.world.WorldBaseGen;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class GuiVeinSensor<T extends ContainerVeinSensor>
extends GuiIU<ContainerVeinSensor> {
    private static final ResourceLocation background = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_scanner_ores.png".toLowerCase());
    private double pointScroll;
    int[][] colors;
    boolean update = false;
    List<Integer> integerList;
    private int value;
    private int maxValue = 0;
    public Map<BlockState, Integer> idToblockStateMap = new HashMap<BlockState, Integer>();
    public Map<Integer, ItemStack> ItemStackMap = new HashMap<Integer, ItemStack>();
    public EditBox searchField;
    public int playerX = 0;
    public int playerY = 0;
    Direction direction = null;

    public GuiVeinSensor(ContainerVeinSensor container, ItemStack itemStack1) {
        super(container);
        this.imageHeight = 178;
        this.imageWidth = 218;
        this.componentList.clear();
        this.colors = new int[144][144];
        this.integerList = (List)itemStack1.getOrDefault(DataComponentsInit.LIST_INTEGER, new ArrayList());
        ArrayList<Map<Vector2, DataOres>> list = new ArrayList<Map<Vector2, DataOres>>(((ItemStackVeinSensor)container.base).getMap().values());
        WorldBaseGen.blockStateMap.forEach((integer, blockstate) -> {
            ItemStack stack = new ItemStack((ItemLike)blockstate.getBlock(), 1);
            if (!this.idToblockStateMap.containsKey(blockstate) && integer != null) {
                this.idToblockStateMap.put((BlockState)blockstate, (Integer)integer);
                this.ItemStackMap.put((Integer)integer, stack);
            }
        });
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                ItemStack stack = new ItemStack((ItemLike)((DataOres)entry.getValue()).getBlockState().getBlock(), 1);
                Integer meta1 = null;
                if (this.idToblockStateMap.containsKey(((DataOres)entry.getValue()).getBlockState()) || !WorldBaseGen.idToblockStateMap.containsKey(((DataOres)entry.getValue()).getBlockState())) {
                    meta1 = this.idToblockStateMap.get(((DataOres)entry.getValue()).getBlockState());
                }
                if (((DataOres)entry.getValue()).getColor() == -1 || meta1 == null || !this.integerList.isEmpty() && !this.integerList.contains(meta1)) continue;
                this.colors[((Vector2)entry.getKey()).getX() - ((ItemStackVeinSensor)container.base).getVector().getX()][((Vector2)entry.getKey()).getZ() - ((ItemStackVeinSensor)container.base).getVector().getZ()] = ((DataOres)entry.getValue()).getColor();
                this.addElement((GuiElement<?>)new Area(this, 19 + ((Vector2)entry.getKey()).getX() - ((ItemStackVeinSensor)container.base).getVector().getX(), 25 + ((Vector2)entry.getKey()).getZ() - ((ItemStackVeinSensor)container.base).getVector().getZ(), 1, 1).withTooltip((Supplier<String>)((Supplier)() -> stack.getDisplayName().getString() + "\nX: " + ((Vector2)entry.getKey()).getX() + "\nZ: " + ((Vector2)entry.getKey()).getZ())));
            }
        }
        int posX = (int)container.player.getX();
        int n = (int)container.player.getZ();
        this.playerX = posX - ((ItemStackVeinSensor)container.base).getVector().getX();
        this.playerY = n - ((ItemStackVeinSensor)container.base).getVector().getZ();
        this.direction = container.player.getMotionDirection();
        this.pointScroll = 127.0 / (double)(this.idToblockStateMap.values().size() - 8);
        this.maxValue = this.idToblockStateMap.values().size() - 8;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (this.searchField.charTyped(codePoint, modifiers)) {
            this.value = 0;
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.minecraft.options.keyInventory.getKey().getValue()) {
            this.searchField.keyPressed(keyCode, scanCode, modifiers);
            this.value = 0;
            return true;
        }
        if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
            this.value = 0;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void init() {
        super.init();
        this.searchField = new EditBox(this.font, this.leftPos + 97, this.topPos + 9, 114, 10, (Component)Component.literal((String)""));
        this.searchField.setMaxLength(25);
        this.searchField.setValue("");
        this.searchField.setCanLoseFocus(true);
        this.searchField.setBordered(false);
        this.addWidget((GuiEventListener)this.searchField);
        this.addRenderableWidget((GuiEventListener)this.searchField);
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d4, double d3) {
        ScrollDirection direction;
        super.mouseScrolled(d, d2, d4, d3);
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : (direction = ScrollDirection.stopped);
        if (mouseX >= 166 && mouseX <= 209 && mouseY >= 24 && mouseY <= 169 && direction != ScrollDirection.stopped) {
            if (direction == ScrollDirection.down) {
                ++this.value;
                this.value = Math.min(this.value, this.maxValue);
            } else {
                --this.value;
                this.value = Math.max(0, this.value);
            }
        }
        return super.mouseScrolled(d, d2, d4, d3);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        int i = 0;
        int j = 0;
        boolean emptySearch = this.searchField.getValue().isEmpty();
        String name = "[" + this.searchField.getValue().toLowerCase();
        if (emptySearch) {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                if (i < this.value) {
                    ++i;
                    continue;
                }
                if (i < Math.min(this.ItemStackMap.values().size(), this.value + 8)) {
                    ((ItemImage)new ItemImage(this, 173, 26 + 18 * j, (Supplier<ItemStack>)((Supplier)entry::getValue)).withTooltip((Supplier<String>)((Supplier)() -> ((ItemStack)entry.getValue()).getDisplayName().getString()))).drawForeground(poseStack, par1, par2);
                    ++j;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                String builder = entry.getValue().getDisplayName().getString().toLowerCase();
                if (!builder.toLowerCase().startsWith(name)) continue;
                if (i < this.value) {
                    ++i;
                    continue;
                }
                ((ItemImage)new ItemImage(this, 173, 26 + 18 * j, (Supplier<ItemStack>)((Supplier)entry::getValue)).withTooltip((Supplier<String>)((Supplier)() -> ((ItemStack)entry.getValue()).getDisplayName().getString()))).drawForeground(poseStack, par1, par2);
                ++i;
                if (++j < 8) continue;
                break;
            }
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        int ii = 0;
        int jj = 0;
        if (this.searchField.mouseClicked((double)i, (double)j, k)) {
            this.searchField.setFocused(true);
            return;
        }
        this.searchField.setFocused(false);
        boolean emptySearch = this.searchField.getValue().isEmpty();
        String name = "[" + this.searchField.getValue().toLowerCase();
        if (emptySearch) {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                if (ii < this.value) {
                    ++ii;
                    continue;
                }
                if (ii < Math.min(this.ItemStackMap.values().size(), this.value + 8)) {
                    String builder = entry.getValue().getDisplayName().getString().toLowerCase();
                    if (!emptySearch && !builder.startsWith(name)) continue;
                    if (x >= 173 && x <= 191 && y >= 26 + 18 * jj && y < 26 + 18 * jj + 18) {
                        new PacketItemStackEvent(entry.getKey(), (Player)this.minecraft.player);
                        this.update = true;
                        if (this.integerList.contains(entry.getKey())) {
                            this.integerList.remove(entry.getKey());
                        } else {
                            this.integerList.add(entry.getKey());
                        }
                    }
                    ++jj;
                    ++ii;
                    continue;
                }
                break;
            }
        } else {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                String builder = entry.getValue().getDisplayName().getString().toLowerCase();
                if (!builder.startsWith(name)) continue;
                if (ii < this.value) {
                    ++ii;
                    continue;
                }
                if (x >= 173 && x <= 191 && y >= 26 + 18 * jj && y < 26 + 18 * jj + 18) {
                    new PacketItemStackEvent(entry.getKey(), (Player)this.minecraft.player);
                    this.update = true;
                    if (this.integerList.contains(entry.getKey())) {
                        this.integerList.remove(entry.getKey());
                    } else {
                        this.integerList.add(entry.getKey());
                    }
                }
                ++ii;
                if (++jj < 8) continue;
                break;
            }
        }
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.update) {
            this.update = false;
            this.elements.clear();
            ArrayList<Map<Vector2, DataOres>> list = new ArrayList<Map<Vector2, DataOres>>(((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getMap().values());
            for (Map map : list) {
                for (Map.Entry entry : map.entrySet()) {
                    ItemStack stack = new ItemStack((ItemLike)((DataOres)entry.getValue()).getBlockState().getBlock(), 1);
                    Integer meta1 = null;
                    if (!this.idToblockStateMap.containsKey(((DataOres)entry.getValue()).getBlockState()) && WorldBaseGen.idToblockStateMap.containsKey(((DataOres)entry.getValue()).getBlockState().getBlock())) {
                        Integer meta = WorldBaseGen.idToblockStateMap.get(((DataOres)entry.getValue()).getBlockState().getBlock());
                        if (meta != null) {
                            this.idToblockStateMap.put(((DataOres)entry.getValue()).getBlockState(), meta);
                            this.ItemStackMap.put(meta, stack);
                            meta1 = meta;
                        }
                    } else {
                        meta1 = this.idToblockStateMap.get(((DataOres)entry.getValue()).getBlockState());
                    }
                    if (((DataOres)entry.getValue()).getColor() != -1 && meta1 != null && (this.integerList.isEmpty() || this.integerList.contains(meta1))) {
                        this.colors[((Vector2)entry.getKey()).getX() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getX()][((Vector2)entry.getKey()).getZ() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getZ()] = ((DataOres)entry.getValue()).getColor();
                        this.addElement((GuiElement<?>)new Area(this, 19 + ((Vector2)entry.getKey()).getX() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getX(), 25 + ((Vector2)entry.getKey()).getZ() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getZ(), 1, 1).withTooltip((Supplier<String>)((Supplier)() -> stack.getDisplayName().getString() + "\nX: " + ((Vector2)entry.getKey()).getX() + "\nZ: " + ((Vector2)entry.getKey()).getZ())));
                        continue;
                    }
                    this.colors[((Vector2)entry.getKey()).getX() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getX()][((Vector2)entry.getKey()).getZ() - ((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).getVector().getZ()] = Blocks.STONE.defaultBlockState().getMapColor((BlockGetter)((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).player.level(), (BlockPos)BlockPos.ZERO).col | 0xFF000000;
                }
            }
            this.pointScroll = 127.0 / (double)(this.idToblockStateMap.values().size() - 8);
            this.maxValue = this.idToblockStateMap.values().size() - 8;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(poseStack, this.guiLeft + 197, (int)((double)(this.guiTop + 25) + (double)this.value * this.pointScroll), 242, 20, 13, 17);
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        boolean empty = true;
        for (int i = 0; i < 144; ++i) {
            for (int j = 0; j < 144; ++j) {
                int color = this.colors[i][j];
                if (color != 0) {
                    this.drawColoredRect(poseStack, 19 + i, 25 + j, 1, 1, this.colors[i][j], bufferBuilder);
                    empty = false;
                    continue;
                }
                this.colors[i][j] = Blocks.STONE.defaultBlockState().getMapColor((BlockGetter)((ItemStackVeinSensor)((ContainerVeinSensor)this.container).base).player.level(), (BlockPos)BlockPos.ZERO).col | 0xFF000000;
            }
        }
        pose.popPose();
        if (!empty) {
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        }
        Tesselator tessellator = Tesselator.getInstance();
        pose = poseStack.pose();
        pose.pushPose();
        int chunkSize = 16;
        int numChunks = 9;
        for (int x = 0; x < numChunks; ++x) {
            for (int y = 0; y < numChunks; ++y) {
                int offsetX = 19 + x * chunkSize;
                int offsetY = 25 + y * chunkSize;
                Matrix4f martix = pose.last().pose();
                BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX + chunkSize), (float)(this.guiTop + offsetY), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX + chunkSize), (float)(this.guiTop + offsetY + chunkSize), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY + chunkSize), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                buffer = tessellator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                buffer.addVertex(martix, (float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY + chunkSize), 0.0f).setColor(0.0f, 1.0f, 0.8f, 1.0f);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            }
        }
        pose.popPose();
        int i = 0;
        int j = 0;
        boolean emptySearch = this.searchField.getValue().isEmpty();
        String name = "[" + this.searchField.getValue().toLowerCase();
        if (emptySearch) {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                if (i < this.value) {
                    ++i;
                    continue;
                }
                if (i < Math.min(this.ItemStackMap.values().size(), this.value + 8)) {
                    String builder = entry.getValue().getDisplayName().getString().toLowerCase();
                    if (this.integerList.contains(entry.getKey())) {
                        this.bindTexture();
                        this.drawTexturedModalRect(poseStack, this.guiLeft + 172, this.guiTop + 25 + 18 * j, 237, 1, 18, 18);
                    }
                    new ItemStackImage(this, 173, 26 + 18 * j, entry::getValue).drawBackground(poseStack, this.guiLeft, this.guiTop);
                    ++j;
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            for (Map.Entry<Integer, ItemStack> entry : this.ItemStackMap.entrySet()) {
                String builder = entry.getValue().getDisplayName().getString().toLowerCase();
                if (!builder.startsWith(name)) continue;
                if (i < this.value) {
                    ++i;
                    continue;
                }
                if (this.integerList.contains(entry.getKey())) {
                    this.bindTexture();
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 172, this.guiTop + 25 + 18 * j, 237, 1, 18, 18);
                }
                new ItemStackImage(this, 173, 26 + 18 * j, entry::getValue).drawBackground(poseStack, this.guiLeft, this.guiTop);
                ++j;
                if (++i < this.value) {
                    ++i;
                    continue;
                }
                if (j < 8) continue;
                break;
            }
        }
        pose.pushPose();
        pose.translate((double)(this.guiLeft + 19 + this.playerX) - 0.5, (double)(this.guiTop + 25 + this.playerY) - 0.5, 20.0);
        switch (this.direction.getOpposite()) {
            case NORTH: {
                pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                pose.mulPose(Axis.ZP.rotationDegrees(0.0f));
                break;
            }
            case WEST: {
                pose.mulPose(Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                pose.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                break;
            }
            case UP: {
                pose.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case DOWN: {
                pose.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
        }
        pose.scale(0.3f, 0.3f, 1.0f);
        GuiVeinSensor.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_icons.png"));
        this.drawTexturedModalRect(poseStack, 0, 0, 29, 120, 13, 22);
        pose.popPose();
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

