/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gascombiner;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class GasCombinerHandler {
    private static final List<GasCombinerHandler> recipes = new ArrayList<GasCombinerHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public GasCombinerHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<GasCombinerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasCombinerHandler.initRecipes();
        }
        return recipes;
    }

    public static GasCombinerHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        GasCombinerHandler recipe = new GasCombinerHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static GasCombinerHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("gas_combiner")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getInput().getInputs().get(1);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(0);
            GasCombinerHandler.addRecipe(fluidStack, fluidStack1, fluidStack2);
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

