/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.incubator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class IncubatorHandler {
    private static final List<IncubatorHandler> recipes = new ArrayList<IncubatorHandler>();
    private final ItemStack input;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public IncubatorHandler(ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        this.input = input;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public static List<IncubatorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            IncubatorHandler.initRecipes();
        }
        return recipes;
    }

    public static IncubatorHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("incubator");
        List<BaseMachineRecipe> list1 = Recipes.recipes.getRecipeList("incubator");
        for (int i = 0; i < list1.size(); ++i) {
            BaseFluidMachineRecipe baseFluidMachineRecipe = list.get(i);
            BaseMachineRecipe baseMachineRecipe = list1.get(i);
            ItemStack input = baseMachineRecipe.input.getInputs().get(0).getInputs().get(0);
            FluidStack inputFluid = baseMachineRecipe.input.getFluid();
            FluidStack outputFluid = baseFluidMachineRecipe.output_fluid.get(0);
            IncubatorHandler.addRecipe(input, inputFluid, outputFluid);
        }
    }

    private static IncubatorHandler addRecipe(ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        IncubatorHandler recipe = new IncubatorHandler(input, inputFluid, outputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }
}

