/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.siliconhandler;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SiliconHandler {
    private static final List<SiliconHandler> recipes = new ArrayList<SiliconHandler>();
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;

    public SiliconHandler(ItemStack input, ItemStack input1, ItemStack output) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
    }

    public static List<SiliconHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SiliconHandler.initRecipes();
        }
        return recipes;
    }

    public static SiliconHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output) {
        SiliconHandler recipe = new SiliconHandler(input, input1, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static SiliconHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (SiliconHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("silicon_recipe")) {
            SiliconHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }

    public List<ItemStack> getInputs1() {
        return Arrays.asList(this.input, this.input1);
    }
}

