/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.solidmatters;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MatterHandler {
    private static final List<MatterHandler> recipes = new ArrayList<MatterHandler>();
    private final ItemStack input;
    private final int energy;

    public MatterHandler(ItemStack input) {
        this.input = input;
        this.energy = 50000000;
    }

    public static List<MatterHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MatterHandler.initRecipes();
        }
        return recipes;
    }

    public static MatterHandler addRecipe(ItemStack input) {
        MatterHandler recipe = new MatterHandler(input);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MatterHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (MatterHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("matter")) {
            MatterHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0));
        }
    }

    public int getEnergy() {
        return this.energy;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

