/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.crystallize;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CrystallizeHandler {
    private static final List<CrystallizeHandler> recipes = new ArrayList<CrystallizeHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public CrystallizeHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<CrystallizeHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CrystallizeHandler.initRecipes();
        }
        return recipes;
    }

    public static CrystallizeHandler addRecipe(ItemStack input, ItemStack output, double need) {
        CrystallizeHandler recipe = new CrystallizeHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CrystallizeHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (CrystallizeHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("defaultcollector")) {
            CrystallizeHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.getDouble("need"));
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

