/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.WirelessConnection;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.tiles.base.TileAnalyzer;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;

public class InvSlotAnalyzer
extends InvSlot
implements ITypeSlot {
    private final int type;
    private final TileAnalyzer tile;
    private int stackSizeLimit;

    public InvSlotAnalyzer(TileAnalyzer base1, String name, int count, int type) {
        super(base1, InvSlot.TypeItemSlot.INPUT, count);
        this.type = type;
        this.stackSizeLimit = 1;
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        if (this.type == 0) {
            return EnumTypeSlot.QUARRY1;
        }
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.macerator = this.macerator();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.polisher = this.polisher();
            this.tile.consume = this.getenergycost();
            this.tile.update_chunk();
            this.tile.furnace = this.getFurnaceModule();
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.consume = this.getenergycost();
            this.tile.macerator = this.macerator();
            this.tile.polisher = this.polisher();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.furnace = this.getFurnaceModule();
        }
        return content;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i).isEmpty() || !(itemStack.getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != IUItem.module9.getMeta((ItemQuarryModule)itemStack.getItem()) || this.get(i).getItem() != itemStack.getItem()) continue;
                return false;
            }
            return itemStack.getItem() instanceof ItemQuarryModule || itemStack.getItem().equals(IUItem.quarrymodule.getItem()) || itemStack.getItem() instanceof ItemAdditionModule && IUItem.module7.getMeta((ItemAdditionModule)itemStack.getItem()) == 10;
        }
        if (this.type == 1) {
            if (itemStack.getItemHolder().tags().collect(Collectors.toList()).size() > 0) {
                List id = itemStack.getItemHolder().tags().collect(Collectors.toList());
                String name = ((TagKey)id.get(0)).location().getPath();
                return name.startsWith("ore");
            }
            return false;
        }
        return false;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public boolean quarry() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !this.get(i).getItem().equals(IUItem.quarrymodule.getItem())) continue;
            return true;
        }
        return false;
    }

    public boolean macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 14) continue;
            return true;
        }
        return false;
    }

    public boolean comb_macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 15) continue;
            return true;
        }
        return false;
    }

    public boolean polisher() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 16) continue;
            return true;
        }
        return false;
    }

    public int lucky() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) < 6 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) >= 9) continue;
            return IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) - 5;
        }
        return 0;
    }

    public boolean getFurnaceModule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getblacklist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 12) continue;
            List listString = (List)this.get(i).getOrDefault(DataComponentsInit.LIST_STRING, Collections.emptyList());
            for (String s : listString) {
                list.add(s);
            }
        }
        return list;
    }

    public List<String> getwhitelist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) != 13) continue;
            List listString = (List)this.get(i).getOrDefault(DataComponentsInit.LIST_STRING, Collections.emptyList());
            for (String s : listString) {
                list.add(s);
            }
            break;
        }
        return list;
    }

    public boolean CheckBlackList(List<String> list, String name) {
        if (list.isEmpty()) {
            return false;
        }
        return !list.contains(name);
    }

    public boolean CheckWhiteList(List<String> list, String name) {
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(name);
    }

    public int getChunksize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) <= 8 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) > 11) continue;
            size = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) - 8;
            return size;
        }
        return size;
    }

    public boolean getwirelessmodule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemAdditionModule) || IUItem.module7.getMeta((ItemAdditionModule)this.get(i).getItem()) != 10) continue;
            return true;
        }
        return false;
    }

    public List<Integer> wirelessmodule() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemAdditionModule) || IUItem.module7.getMeta((ItemAdditionModule)this.get(i).getItem()) != 10) continue;
            WirelessConnection wirelessConnection = (WirelessConnection)this.get(i).getOrDefault(DataComponentsInit.WIRELESS, (Object)WirelessConnection.EMPTY);
            int x = wirelessConnection.x();
            int y = wirelessConnection.y();
            int z = wirelessConnection.z();
            if (x == 0 || y == 0 || z == 0) break;
            list.add(x);
            list.add(y);
            list.add(z);
            break;
        }
        return list;
    }

    public double getenergycost(TileBaseQuantumQuarry target1) {
        double energy = target1.energyconsume;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) <= 0 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) >= 6) continue;
            double proccent = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem());
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }

    public double getenergycost() {
        double energy = 1000.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty() || !(this.get(i).getItem() instanceof ItemQuarryModule) || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) <= 0 || IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem()) >= 6) continue;
            double proccent = IUItem.module9.getMeta((ItemQuarryModule)this.get(i).getItem());
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }
}

