/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.blocks.ISubEnum;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.tiles.base.TileAutoSpawner;
import com.denfop.utils.CapturedMobUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InvSlotModules
extends InvSlot {
    private final TileAutoSpawner tile;
    private int stackSizeLimit;

    public InvSlotModules(TileAutoSpawner base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 4);
        this.tile = base1;
        this.stackSizeLimit = 1;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (!(itemStack.getItem() instanceof ItemEntityModule)) {
            return false;
        }
        if (((ISubEnum)((ItemEntityModule)itemStack.getItem()).getElement()).getId() == 0) {
            return false;
        }
        return CapturedMobUtils.containsSoul(itemStack);
    }

    @Override
    public void update() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).isEmpty()) {
                LivingEntity entityLiving;
                CapturedMobUtils captured = CapturedMobUtils.create(this.get(i), this.tile.registryAccess());
                assert (captured != CapturedMobUtils.EMPTY);
                this.tile.mobUtils[i] = entityLiving = (LivingEntity)captured.getEntity(this.tile.getWorld(), true);
                this.tile.loot_Tables[i] = IUCore.lootTables.get(captured.getResource());
                this.tile.maxprogress[i] = 100.0 * captured.getCoefficient();
                this.tile.description_mobs[i] = entityLiving.getName().getString() + "\n" + Localization.translate("iu.show.health") + (int)entityLiving.getHealth() + "/" + (int)entityLiving.getMaxHealth() + "\n" + Localization.translate("iu.show.speed") + (int)this.tile.maxprogress[i];
                continue;
            }
            this.tile.mobUtils[i] = null;
            this.tile.loot_Tables[i] = null;
            this.tile.lootContext[i] = null;
            this.tile.maxprogress[i] = 100.0;
            this.tile.description_mobs[i] = "";
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        if (!content.isEmpty()) {
            LivingEntity entityLiving;
            this.tile.mobUtils[index] = null;
            this.tile.loot_Tables[index] = null;
            this.tile.lootContext[index] = null;
            this.tile.maxprogress[index] = 100.0;
            this.tile.description_mobs[index] = "";
            CapturedMobUtils captured = CapturedMobUtils.create(content, this.tile.registryAccess());
            assert (captured != null);
            this.tile.mobUtils[index] = entityLiving = (LivingEntity)captured.getEntity(this.tile.getWorld(), true);
            this.tile.maxprogress[index] = 100.0 * captured.getCoefficient();
            this.tile.loot_Tables[index] = IUCore.lootTables.get(captured.getResource());
            this.tile.description_mobs[index] = entityLiving.getName().getString() + "\n" + Localization.translate("iu.show.health") + (int)entityLiving.getHealth() + "/" + (int)entityLiving.getMaxHealth() + "\n" + Localization.translate("iu.show.speed") + (int)this.tile.maxprogress[index];
        } else {
            this.tile.mobUtils[index] = null;
            this.tile.loot_Tables[index] = null;
            this.tile.lootContext[index] = null;
            this.tile.maxprogress[index] = 100.0;
            this.tile.description_mobs[index] = "";
        }
        return content;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }
}

