/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SlotArmor
extends Slot {
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private final EquipmentSlot armorType;

    public SlotArmor(Inventory inventory, EquipmentSlot armorType, int x, int y) {
        super((Container)inventory, 36 + armorType.getIndex(), x, y);
        this.armorType = armorType;
    }

    public EquipmentSlot getEquipmentSlotForItem(ItemStack p_147234_) {
        EquipmentSlot equipmentslot;
        EquipmentSlot slot = p_147234_.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.get((ItemStack)p_147234_);
        if (equipable != null && (equipmentslot = equipable.getEquipmentSlot()) != EquipmentSlot.BODY) {
            return equipmentslot;
        }
        return EquipmentSlot.MAINHAND;
    }

    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (item == null) {
            return false;
        }
        return this.getEquipmentSlotForItem(stack) == this.armorType;
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[this.armorType.getIndex()]);
    }
}

