/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.recipes.ScrapboxRecipeManager;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class IUItemBase
extends Item
implements IItemTab {
    private CreativeModeTab tabCore;
    private String nameItem;

    public IUItemBase() {
        super(new Item.Properties());
    }

    public IUItemBase(CreativeModeTab tabCore) {
        super(new Item.Properties());
        this.tabCore = tabCore;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand hand) {
        if (!player.getItemInHand(hand).is(IUItem.doublescrapBox.getItem())) {
            return super.use(pLevel, player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        for (int i = 0; i < 9; ++i) {
            if (pLevel.isClientSide) continue;
            ItemStack drop = ScrapboxRecipeManager.instance.getDrop(IUItem.scrapBox);
            player.drop(drop, false);
        }
        stack.shrink(1);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem + ".name";
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return this.tabCore == null ? IUCore.ItemTab : this.tabCore;
    }
}

