/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.world.GenData;
import com.denfop.world.WorldGenGas;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ItemGasSensor
extends Item
implements IItemTab {
    private String nameItem;

    public ItemGasSensor() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.gas_sensor.info")));
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.gas_sensor.info1")));
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.gas_sensor.info2")));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        ChunkPos chunkPos = new ChunkPos((int)player.getX() >> 4, (int)player.getZ() >> 4);
        boolean empty = true;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                ChunkPos chunkPos1 = new ChunkPos(chunkPos.x + i, chunkPos.z + j);
                GenData typeGas = WorldGenGas.gasMap.get(chunkPos1);
                if (typeGas == null) continue;
                empty = false;
                MutableComponent text = Component.literal((String)"");
                switch (typeGas.getTypeGas()) {
                    case GAS: {
                        text = Component.translatable((String)((IUFluid)((Object)FluidName.fluidgas.getInstance().get())).getFluidType().getDescriptionId());
                        break;
                    }
                    case IODINE: {
                        text = Component.translatable((String)((IUFluid)((Object)FluidName.fluidiodine.getInstance().get())).getFluidType().getDescriptionId());
                        break;
                    }
                    case BROMIDE: {
                        text = Component.translatable((String)((IUFluid)((Object)FluidName.fluidbromine.getInstance().get())).getFluidType().getDescriptionId());
                        break;
                    }
                    case CHLORINE: {
                        text = Component.translatable((String)((IUFluid)((Object)FluidName.fluidchlorum.getInstance().get())).getFluidType().getDescriptionId());
                        break;
                    }
                    case FLUORINE: {
                        text = Component.translatable((String)((IUFluid)((Object)FluidName.fluidfluor.getInstance().get())).getFluidType().getDescriptionId());
                    }
                }
                if (typeGas.getX() == 0 && typeGas.getZ() == 0) {
                    IUCore.proxy.messagePlayer(player, Component.literal((String)("X: " + (chunkPos1.getMinBlockX() + 16) + ", Y: " + typeGas.getY() + ", Z: " + (chunkPos1.getMinBlockZ() + 16) + " " + text.getString())).getString());
                    continue;
                }
                IUCore.proxy.messagePlayer(player, Component.literal((String)("X: " + typeGas.getX() + ", Y: " + typeGas.getY() + ", Z: " + typeGas.getZ() + " --> " + text.getString())).getString());
            }
        }
        if (empty) {
            IUCore.proxy.messagePlayer(player, Component.translatable((String)"iu.empty").getString());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }
}

