/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.FluidHandlerFix;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class ItemPipette
extends ItemFluidContainer
implements IItemTab {
    public ItemPipette() {
        super(10000, 1);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, level, list, tooltipFlag);
        list.add((Component)Component.literal((String)Localization.translate("iu.pipette.info")));
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        IFluidHandlerItem handler;
        FluidStack fluid;
        if (!world.isClientSide && player.isShiftKeyDown() && !(fluid = (handler = FluidHandlerFix.getFluidHandler(stack = player.getItemInHand(hand))).getFluidInTank(0)).isEmpty()) {
            handler.drain(fluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }
}

