/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IProperties;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.Keyboard;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemRecipeSchedule
extends Item
implements IItemTab,
IProperties {
    private final String name;

    public ItemRecipeSchedule() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
        this.name = "recipe_schedule";
        IUCore.proxy.addProperties(this);
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return (Boolean)itemStack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false) != false ? 1.0f : 0.0f;
    }

    public List<ItemStack> getItems(ItemStack stack) {
        return (List)stack.getOrDefault(DataComponentsInit.LIST_STACK, Collections.emptyList());
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            for (ItemStack description : this.getItems(stack)) {
                tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + description.getHoverName().getString())));
            }
        }
    }

    public RecipeArrayList<IRecipeInputStack> getInputs(HolderLookup.Provider provider, IBaseRecipe baseRecipe, ItemStack stack) {
        return this.getInputs(baseRecipe, stack);
    }

    public RecipeArrayList<IRecipeInputStack> getInputs(IBaseRecipe baseRecipe, ItemStack stack) {
        List<ItemStack> items = this.getItems(stack);
        List<BaseMachineRecipe> recipe_list = Recipes.recipes.getRecipeList(baseRecipe.getName());
        if (((Boolean)stack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false)).booleanValue()) {
            if (items.isEmpty()) {
                return new RecipeArrayList<IRecipeInputStack>();
            }
            RecipeArrayList<IRecipeInputStack> recipeArrayList = new RecipeArrayList<IRecipeInputStack>();
            for (BaseMachineRecipe baseMachineRecipe : recipe_list) {
                boolean find = false;
                block1: for (ItemStack output_schedule : items) {
                    for (ItemStack output : baseMachineRecipe.output.items) {
                        if (!output.is(output_schedule.getItem())) continue;
                        find = true;
                        break block1;
                    }
                }
                if (!find) continue;
                baseMachineRecipe.input.getInputs().forEach(iInputItemStack -> recipeArrayList.add(new RecipeInputStack((IInputItemStack)iInputItemStack)));
            }
            return recipeArrayList;
        }
        if (items.isEmpty()) {
            return Recipes.recipes.getMap_recipe_managers_itemStack(baseRecipe.getName());
        }
        RecipeArrayList<IRecipeInputStack> recipeArrayList = new RecipeArrayList<IRecipeInputStack>();
        for (BaseMachineRecipe baseMachineRecipe : recipe_list) {
            boolean find = false;
            block4: for (ItemStack output_schedule : items) {
                for (ItemStack output : baseMachineRecipe.output.items) {
                    if (output.is(output_schedule.getItem())) continue;
                    find = true;
                    break block4;
                }
            }
            if (!find) continue;
            baseMachineRecipe.input.getInputs().forEach(iInputItemStack -> recipeArrayList.add(new RecipeInputStack((IInputItemStack)iInputItemStack)));
        }
        return recipeArrayList;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }
}

