/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.IBee;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.blocks.ISubEnum;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IProperties;
import com.denfop.items.ItemMain;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemJarBees<T extends Enum<T>>
extends ItemMain<T>
implements IProperties {
    public ItemJarBees(T element) {
        super(new Item.Properties(), element);
        IUCore.proxy.addProperties(this);
    }

    public static IBee getBee(ItemStack stack) {
        IBee bee = BeeNetwork.instance.getBee((Integer)stack.getOrDefault(DataComponentsInit.BEE, (Object)0));
        if (bee == null) {
            return null;
        }
        return bee.copy();
    }

    public ItemStack getStackFromId(int id) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponentsInit.BEE, (Object)id);
        return stack;
    }

    @Override
    public void fillItemCategory(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.allowedIn(tab)) {
            BeeNetwork.instance.getBeeMap().forEach((id, crop) -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                stack.set(DataComponentsInit.BEE, id);
                items.add((Object)stack);
            });
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.BeesTab;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        Genome genome;
        tooltip.add((Component)Component.translatable((String)"iu.use_bee_analyzer").append((Component)Component.translatable((String)IUItem.bee_analyzer.getItem().getDescriptionId())));
        IBee bee = ItemJarBees.getBee(stack);
        tooltip.add((Component)Component.literal((String)(Localization.translate("iu.bee_analyzer.main_crop") + " " + Localization.translate("crop." + bee.getCropFlower().getName()))));
        tooltip.add((Component)Component.translatable((String)"iu.bee_negative"));
        if (bee != null) {
            List<IBee> unCompatibleBees = bee.getUnCompatibleBees();
            for (IBee bee1 : unCompatibleBees) {
                tooltip.add((Component)Component.translatable((String)("bee_" + bee1.getName())));
            }
        }
        if (stack.has(DataComponentsInit.SWARM)) {
            int swarm = (Integer)stack.get(DataComponentsInit.SWARM);
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.bee.swarm.info") + String.valueOf(swarm))));
        }
        if (!(genome = new Genome(stack)).getGeneticTraitsMap().isEmpty()) {
            tooltip.add((Component)Component.literal((String)Localization.translate("iu.genomes.info")));
            genome.getGeneticTraitsMap().values().forEach(value -> tooltip.add((Component)Component.literal((String)Localization.translate("iu.info.bee_genome_" + value.name().toLowerCase()))));
        }
    }

    public Component getName(ItemStack stack) {
        if (ItemJarBees.getBee(stack) != null) {
            IBee crop = BeeNetwork.instance.getBee((Integer)stack.getOrDefault(DataComponentsInit.BEE, (Object)0));
            return Component.translatable((String)super.getDescriptionId(stack)).append(": ").append((Component)Component.translatable((String)("bee_" + crop.getName())));
        }
        return Component.translatable((String)super.getDescriptionId(stack));
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return ((Integer)itemStack.getOrDefault(DataComponentsInit.BEE, (Object)0)).intValue();
    }

    public ItemStack getBeeStack(int meta) {
        ItemStack stack = this.getStackFromId(meta);
        IBee bee = ItemJarBees.getBee(stack);
        stack.set(DataComponentsInit.SWARM, (Object)(WorldBaseGen.random.nextInt(bee.getMaxSwarm() / 2) + 15));
        return stack;
    }

    public static enum Types implements ISubEnum
    {
        bees;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "jar_bee";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

