/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.container.ContainerBase;
import com.denfop.datacomponent.ContainerAdditionalItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.gui.GuiCore;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.bags.BagsDescription;
import com.denfop.items.energy.ContainerMagnet;
import com.denfop.items.energy.GuiMagnet;
import com.denfop.items.energy.ItemMagnet;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStackMagnet
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public final List<ItemStack> list;
    public ContainerAdditionalItem containerAdditionItem;

    public ItemStackMagnet(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.containerAdditionItem = (ContainerAdditionalItem)this.containerStack.get(DataComponentsInit.CONTAINER_ADDITIONAL);
        if (this.containerAdditionItem == null) {
            this.containerAdditionItem = ContainerAdditionalItem.EMPTY.updateItems(this.containerStack, new ArrayList<ItemStack>());
            this.containerStack.set(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)this.containerAdditionItem);
        }
        if (this.containerAdditionItem.listItem().isEmpty()) {
            Object[] object = new ItemStack[9];
            Arrays.fill(object, ItemStack.EMPTY);
            List<Object> list = Arrays.asList(object);
            this.containerAdditionItem = this.containerAdditionItem.updateItems(this.containerStack, list);
        }
        this.list = this.containerAdditionItem.listItem();
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public ItemStack getItem(int slot) {
        return slot >= this.inventorySize ? this.list.get(slot - this.inventorySize) : (ItemStack)this.inventory.get(slot);
    }

    @Override
    public void save() {
        super.save();
        if (!this.player.level().isClientSide && !this.cleared) {
            boolean dropItself = false;
            for (int i = 0; i < this.list.size(); ++i) {
                if (!this.isThisContainer(this.list.get(i))) continue;
                this.list.set(i, ItemStack.EMPTY);
                dropItself = true;
            }
            ListTag contentList = new ListTag();
            this.containerAdditionItem = this.containerAdditionItem.updateItems(this.containerStack, this.list);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.level(), this.player.blockPosition(), this.containerStack);
                this.clear();
            } else {
                int idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.clear();
                } else if (idx == -1) {
                    this.player.getInventory().setPickedItem(this.containerStack);
                } else {
                    this.player.getInventory().setItem(idx, this.containerStack);
                }
            }
        }
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (slot < this.inventory.size()) {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            if (ModUtils.isEmpty(stack)) {
                this.inventory.set(slot, ModUtils.emptyStack);
            } else {
                this.inventory.set(slot, stack);
            }
        } else {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            if (ModUtils.isEmpty(stack)) {
                this.list.set(slot - this.inventory.size(), ModUtils.emptyStack);
            } else {
                this.list.set(slot - this.inventory.size(), stack);
            }
        }
        this.updatelist();
        this.save();
    }

    private void updatelist() {
        ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
        for (ItemStack stack : this.inventory) {
            if (stack == null || stack.isEmpty()) continue;
            if (list.isEmpty()) {
                list.add(new BagsDescription(stack));
                continue;
            }
            if (list.contains(new BagsDescription(stack))) {
                for (BagsDescription bagsDescription : list) {
                    if (!bagsDescription.equals(new BagsDescription(stack))) continue;
                    bagsDescription.addCount(stack.getCount());
                }
                continue;
            }
            list.add(new BagsDescription(stack));
        }
        this.itemStack1.set(DataComponentsInit.DESCRIPTIONS_CONTAINER, list);
    }

    private boolean addWithoutSave(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            boolean white = (Boolean)this.itemStack1.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false);
            for (ItemStack stack : stacks) {
                boolean can = false;
                if (white) {
                    for (ItemStack stack1 : this.list) {
                        if (stack1.isEmpty() || !stack1.is(stack.getItem())) continue;
                        can = true;
                        break;
                    }
                } else {
                    for (ItemStack stack1 : this.list) {
                        if (!stack1.isEmpty() && stack1.is(stack.getItem())) {
                            can = false;
                            break;
                        }
                        can = true;
                    }
                }
                if (!can) {
                    return false;
                }
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (this.get(i) == null || this.get(i).isEmpty()) {
                        if (!simulate) {
                            this.putWithoutSave(i, stack.copy());
                            stack.setCount(0);
                        }
                        return true;
                    }
                    if (!this.get(i).is(stack.getItem()) || this.get(i).getCount() + stack.getCount() > stack.getMaxStackSize()) continue;
                    if (stack.getComponents().isEmpty() && this.get(i).getComponents().isEmpty()) {
                        if (!simulate) {
                            this.get(i).grow(stack.getCount());
                            stack.setCount(0);
                        }
                        return true;
                    }
                    if (stack.getComponents().isEmpty() || !stack.getComponents().equals((Object)this.get(i).getComponents())) continue;
                    if (!simulate) {
                        this.get(i).grow(stack.getCount());
                        stack.setCount(0);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean addWithoutSave(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addWithoutSave(Collections.singletonList(stack), false);
    }

    public void putWithoutSave(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory.set(index, content);
        this.save();
    }

    @Override
    public ItemStack removeItem(int index, int amount) {
        ItemStack stack;
        if (index < this.inventory.size()) {
            ItemStack stack2;
            if (index >= 0 && index < this.inventory.size() && !ModUtils.isEmpty(stack2 = (ItemStack)this.inventory.get(index))) {
                ItemStack ret;
                if (amount >= ModUtils.getSize(stack2)) {
                    ret = stack2;
                    this.inventory.set(index, ModUtils.emptyStack);
                } else {
                    ret = ModUtils.setSize(stack2, amount);
                    this.inventory.set(index, ModUtils.decSize(stack2, amount));
                }
                this.save();
                return ret;
            }
            return ModUtils.emptyStack;
        }
        if (index - this.inventory.size() < this.list.size() && !ModUtils.isEmpty(stack = this.list.get(index - this.inventory.size()))) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.list.set(index - this.inventory.size(), ModUtils.emptyStack);
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.list.set(index - this.inventory.size(), ModUtils.decSize(stack, amount));
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player var1, ContainerBase<?> menu) {
        ContainerMagnet containerLeadBox = (ContainerMagnet)menu;
        return new GuiMagnet(containerLeadBox, this.itemStack1);
    }

    public ContainerMagnet getGuiContainer(Player player) {
        return new ContainerMagnet(player, this);
    }

    @Override
    public boolean canPlaceItem(int p_18952_, ItemStack itemstack) {
        if (itemstack.getItem() instanceof ItemMagnet) {
            return false;
        }
        boolean white = (Boolean)this.itemStack1.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false);
        boolean can = false;
        if (white) {
            for (ItemStack stack1 : this.list) {
                if (stack1.isEmpty() || !stack1.is(itemstack.getItem())) continue;
                can = true;
                break;
            }
        } else {
            for (ItemStack stack1 : this.list) {
                if (!stack1.isEmpty() && stack1.is(itemstack.getItem())) {
                    can = false;
                    break;
                }
                can = true;
            }
        }
        if (!can) {
            return false;
        }
        return !itemstack.isEmpty();
    }
}

