/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.energy.ItemToolWrench;
import com.denfop.utils.ModUtils;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemToolWrenchEnergy
extends ItemToolWrench
implements IEnergyItem {
    @Override
    public boolean canTakeDamage(ItemStack stack, int amount) {
        return ElectricItem.manager.getCharge(stack) >= (double)(amount *= 100);
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public void damage(ItemStack stack, int amount, Player player) {
        ElectricItem.manager.use(stack, 100 * amount, (LivingEntity)player);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 12000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 250.0;
    }
}

