/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.modules;

import com.denfop.IUCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.ItemMain;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemEntityModule<T extends Enum<T>>
extends ItemMain<T> {
    public ItemEntityModule(T element) {
        super(new Item.Properties(), element);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (((ISubEnum)this.getElement()).getId() == 1 && player.isShiftKeyDown()) {
            stack.set(DataComponentsInit.MOB, (Object)CapturedMobUtils.EMPTY);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ModuleTab;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        String nbt;
        super.appendHoverText(stack, level, tooltip, flag);
        if (((ISubEnum)this.getElement()).getId() != 1 && (nbt = (String)stack.get(DataComponentsInit.NAME)) != null && !nbt.isEmpty()) {
            tooltip.add((Component)Component.literal((String)nbt));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (((ISubEnum)this.getElement()).getId() == 1) {
            if (entity instanceof Player) {
                return InteractionResult.FAIL;
            }
            CapturedMobUtils captured = CapturedMobUtils.create((Entity)entity);
            if (captured == CapturedMobUtils.EMPTY) {
                return InteractionResult.FAIL;
            }
            ItemStack resultStack = ModUtils.setSize(stack, 1);
            entity.discard();
            stack.shrink(1);
            resultStack.set(DataComponentsInit.MOB, (Object)captured);
            if (!player.level().isClientSide()) {
                double dx = player.level().random.nextDouble() * 0.7 + 0.15;
                double dy = player.level().random.nextDouble() * 0.7 + 0.15;
                double dz = player.level().random.nextDouble() * 0.7 + 0.15;
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX() + dx, player.getY() + dy, player.getZ() + dz, resultStack);
                itemEntity.setPickUpDelay(10);
                player.level().addFreshEntity((Entity)itemEntity);
            }
            return InteractionResult.SUCCESS;
        }
        if (((ISubEnum)this.getElement()).getId() == 0) {
            if (entity instanceof Player) {
                ItemStack stackCopy = stack.copy();
                CompoundTag tag = new CompoundTag();
                tag.putString("name", entity.getDisplayName().getString());
                if (!player.level().isClientSide()) {
                    stack.shrink(1);
                    double dx = player.level().random.nextDouble() * 0.7 + 0.15;
                    double dy = player.level().random.nextDouble() * 0.7 + 0.15;
                    double dz = player.level().random.nextDouble() * 0.7 + 0.15;
                    ItemEntity itemEntity = new ItemEntity(player.level(), player.getX() + dx, player.getY() + dy, player.getZ() + dz, stackCopy);
                    itemEntity.setPickUpDelay(10);
                    player.level().addFreshEntity((Entity)itemEntity);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static enum Types implements ISubEnum
    {
        module_player(0),
        module_mob(1);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "entitymodules";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

