/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.relocator;

import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerRelocator;
import com.denfop.container.ContainerRelocatorAddPoint;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiRelocator;
import com.denfop.gui.GuiRelocatorAddPoint;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStackRelocator
extends ItemStackInventory {
    public final ItemStack itemStack1;
    private final boolean sneaking;
    public List<Point> points = new ArrayList<Point>();

    public ItemStackRelocator(Player player, ItemStack stack) {
        super(player, stack, 0);
        this.itemStack1 = stack;
        this.sneaking = player.isShiftKeyDown();
        if (!player.level().isClientSide) {
            this.points = new ArrayList<Point>(RelocatorNetwork.instance.getPoints(player));
        }
    }

    @Override
    public CustomPacketBuffer writeContainer() {
        CustomPacketBuffer customPacketBuffer = super.writeContainer();
        return customPacketBuffer;
    }

    @Override
    public void readContainer(CustomPacketBuffer buffer) {
        super.readContainer(buffer);
    }

    @Override
    public ContainerBase<ItemStackRelocator> getGuiContainer(Player player) {
        if (this.sneaking) {
            return new ContainerRelocatorAddPoint(this);
        }
        return new ContainerRelocator(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player player, ContainerBase<?> isAdmin) {
        if (this.sneaking) {
            return new GuiRelocatorAddPoint(isAdmin);
        }
        return new GuiRelocator(isAdmin);
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }
}

