/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.Recipes;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.IURecipeDelete;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class IUDeleteRecipeSerializer
implements RecipeSerializer<IURecipeDelete> {
    public static final MapCodec<IURecipeDelete> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("fluid".equals(type)) {
                return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
            }
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        return builder.group((App)Codec.STRING.fieldOf("recipe_type").forGetter(IURecipeDelete::getRecipeType), (App)Codec.BOOL.fieldOf("isFluidRecipe").orElse((Object)false).forGetter(IURecipeDelete::isFluid), (App)Codec.list((Codec)singleInputCodec).fieldOf("output").forGetter(IURecipeDelete::getInputsAll), (App)Codec.BOOL.fieldOf("isRemoveAll").orElse((Object)false).forGetter(IURecipeDelete::isRemoveAll)).apply((Applicative)builder, (recipeType, isFluidRecipe, inputs1, removeAll) -> {
            ArrayList<ItemStack> outputs1 = new ArrayList<ItemStack>();
            ArrayList<FluidStack> outputsFluid = new ArrayList<FluidStack>();
            for (IInputItemStack o : inputs1) {
                if (o instanceof InputFluidStack) {
                    outputsFluid.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                outputs1.add(o.getInputs().get(0));
            }
            if (isFluidRecipe.booleanValue() && !outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidRemoveRecipe((String)recipeType, (FluidStack)outputsFluid.get(0), (boolean)removeAll);
            }
            if (!outputs1.isEmpty()) {
                Recipes.recipes.addRemoveRecipe((String)recipeType, (ItemStack)outputs1.get(0), (boolean)removeAll);
            }
            return new IURecipeDelete((String)recipeType, (Boolean)isFluidRecipe, (List<IInputItemStack>)inputs1, (boolean)removeAll);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, IURecipeDelete> STREAM_CODEC = StreamCodec.of(IUDeleteRecipeSerializer::toNetwork, IUDeleteRecipeSerializer::fromNetwork);

    private static IURecipeDelete fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new IURecipeDelete("", false, new ArrayList<IInputItemStack>(), false);
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, IURecipeDelete p_320586_) {
    }

    public MapCodec<IURecipeDelete> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, IURecipeDelete> streamCodec() {
        return STREAM_CODEC;
    }
}

