/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PotionRecipes {
    public static final List<Ingredient> containers = new ArrayList<Ingredient>();
    public static final List<Mix<Potion>> potionMixes = new ArrayList<Mix<Potion>>();
    public static final List<Mix<Item>> containerMixes = new ArrayList<Mix<Item>>();

    public static void init() {
        PotionRecipes.addContainer(Items.POTION);
        PotionRecipes.addContainer(Items.SPLASH_POTION);
        PotionRecipes.addContainer(Items.LINGERING_POTION);
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.THICK);
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER, Items.REDSTONE, (Holder<Potion>)Potions.MUNDANE);
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER, Items.NETHER_WART, (Holder<Potion>)Potions.AWKWARD);
        PotionRecipes.addStartMix(Items.BREEZE_ROD, (Holder<Potion>)Potions.WIND_CHARGED);
        PotionRecipes.addStartMix(Items.SLIME_BLOCK, (Holder<Potion>)Potions.OOZING);
        PotionRecipes.addStartMix(Items.STONE, (Holder<Potion>)Potions.INFESTED);
        PotionRecipes.addStartMix(Items.COBWEB, (Holder<Potion>)Potions.WEAVING);
        PotionRecipes.addMix((Holder<Potion>)Potions.AWKWARD, Items.GOLDEN_CARROT, (Holder<Potion>)Potions.NIGHT_VISION);
        PotionRecipes.addMix((Holder<Potion>)Potions.NIGHT_VISION, Items.REDSTONE, (Holder<Potion>)Potions.LONG_NIGHT_VISION);
        PotionRecipes.addMix((Holder<Potion>)Potions.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.INVISIBILITY);
        PotionRecipes.addMix((Holder<Potion>)Potions.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.LONG_INVISIBILITY);
        PotionRecipes.addMix((Holder<Potion>)Potions.INVISIBILITY, Items.REDSTONE, (Holder<Potion>)Potions.LONG_INVISIBILITY);
        PotionRecipes.addStartMix(Items.MAGMA_CREAM, (Holder<Potion>)Potions.FIRE_RESISTANCE);
        PotionRecipes.addMix((Holder<Potion>)Potions.FIRE_RESISTANCE, Items.REDSTONE, (Holder<Potion>)Potions.LONG_FIRE_RESISTANCE);
        PotionRecipes.addStartMix(Items.RABBIT_FOOT, (Holder<Potion>)Potions.LEAPING);
        PotionRecipes.addMix((Holder<Potion>)Potions.LEAPING, Items.REDSTONE, (Holder<Potion>)Potions.LONG_LEAPING);
        PotionRecipes.addMix((Holder<Potion>)Potions.LEAPING, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_LEAPING);
        PotionRecipes.addMix((Holder<Potion>)Potions.LEAPING, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.SLOWNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.LONG_SLOWNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.SLOWNESS, Items.REDSTONE, (Holder<Potion>)Potions.LONG_SLOWNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.SLOWNESS, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_SLOWNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.AWKWARD, Items.TURTLE_HELMET, (Holder<Potion>)Potions.TURTLE_MASTER);
        PotionRecipes.addMix((Holder<Potion>)Potions.TURTLE_MASTER, Items.REDSTONE, (Holder<Potion>)Potions.LONG_TURTLE_MASTER);
        PotionRecipes.addMix((Holder<Potion>)Potions.TURTLE_MASTER, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_TURTLE_MASTER);
        PotionRecipes.addMix((Holder<Potion>)Potions.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.SLOWNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.LONG_SLOWNESS);
        PotionRecipes.addStartMix(Items.SUGAR, (Holder<Potion>)Potions.SWIFTNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.SWIFTNESS, Items.REDSTONE, (Holder<Potion>)Potions.LONG_SWIFTNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.SWIFTNESS, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_SWIFTNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.AWKWARD, Items.PUFFERFISH, (Holder<Potion>)Potions.WATER_BREATHING);
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER_BREATHING, Items.REDSTONE, (Holder<Potion>)Potions.LONG_WATER_BREATHING);
        PotionRecipes.addStartMix(Items.GLISTERING_MELON_SLICE, (Holder<Potion>)Potions.HEALING);
        PotionRecipes.addMix((Holder<Potion>)Potions.HEALING, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_HEALING);
        PotionRecipes.addMix((Holder<Potion>)Potions.HEALING, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.HARMING);
        PotionRecipes.addMix((Holder<Potion>)Potions.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.STRONG_HARMING);
        PotionRecipes.addMix((Holder<Potion>)Potions.HARMING, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_HARMING);
        PotionRecipes.addMix((Holder<Potion>)Potions.POISON, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.HARMING);
        PotionRecipes.addMix((Holder<Potion>)Potions.LONG_POISON, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.HARMING);
        PotionRecipes.addMix((Holder<Potion>)Potions.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.STRONG_HARMING);
        PotionRecipes.addStartMix(Items.SPIDER_EYE, (Holder<Potion>)Potions.POISON);
        PotionRecipes.addMix((Holder<Potion>)Potions.POISON, Items.REDSTONE, (Holder<Potion>)Potions.LONG_POISON);
        PotionRecipes.addMix((Holder<Potion>)Potions.POISON, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_POISON);
        PotionRecipes.addStartMix(Items.GHAST_TEAR, (Holder<Potion>)Potions.REGENERATION);
        PotionRecipes.addMix((Holder<Potion>)Potions.REGENERATION, Items.REDSTONE, (Holder<Potion>)Potions.LONG_REGENERATION);
        PotionRecipes.addMix((Holder<Potion>)Potions.REGENERATION, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_REGENERATION);
        PotionRecipes.addStartMix(Items.BLAZE_POWDER, (Holder<Potion>)Potions.STRENGTH);
        PotionRecipes.addMix((Holder<Potion>)Potions.STRENGTH, Items.REDSTONE, (Holder<Potion>)Potions.LONG_STRENGTH);
        PotionRecipes.addMix((Holder<Potion>)Potions.STRENGTH, Items.GLOWSTONE_DUST, (Holder<Potion>)Potions.STRONG_STRENGTH);
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER, Items.FERMENTED_SPIDER_EYE, (Holder<Potion>)Potions.WEAKNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.WEAKNESS, Items.REDSTONE, (Holder<Potion>)Potions.LONG_WEAKNESS);
        PotionRecipes.addMix((Holder<Potion>)Potions.AWKWARD, Items.PHANTOM_MEMBRANE, (Holder<Potion>)Potions.SLOW_FALLING);
        PotionRecipes.addMix((Holder<Potion>)Potions.SLOW_FALLING, Items.REDSTONE, (Holder<Potion>)Potions.LONG_SLOW_FALLING);
    }

    public static void expectPotion(Item p_341194_) {
        if (!(p_341194_ instanceof PotionItem)) {
            throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)p_341194_)));
        }
    }

    public static void addContainer(Item p_340911_) {
        PotionRecipes.expectPotion(p_340911_);
        containers.add(Ingredient.of((ItemLike[])new ItemLike[]{p_340911_}));
    }

    public static void addMix(Holder<Potion> p_341151_, Item p_341216_, Holder<Potion> p_340841_) {
        potionMixes.add(new Mix<Potion>(p_341151_, Ingredient.of((ItemLike[])new ItemLike[]{p_341216_}), p_340841_));
    }

    public static void addStartMix(Item p_341103_, Holder<Potion> p_341346_) {
        PotionRecipes.addMix((Holder<Potion>)Potions.WATER, p_341103_, (Holder<Potion>)Potions.MUNDANE);
        PotionRecipes.addMix((Holder<Potion>)Potions.AWKWARD, p_341103_, p_341346_);
    }

    public record Mix<T>(Holder<T> from, Ingredient ingredient, Holder<T> to) {
    }
}

