/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.rocketpad;

import com.denfop.IUItem;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.render.rocketpad.DataRocket;
import com.denfop.tiles.mechanism.TileEntityRocketLaunchPad;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector3f;

public class RocketPadRender {
    public static void render(TileEntityRocketLaunchPad te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        if (te.rocketList.isEmpty() && !te.roverSlot.get(0).isEmpty()) {
            ItemStack rocket = te.roverSlot.get(0);
            switch (((IRoversItem)rocket.getItem()).getLevel()) {
                case ONE: {
                    rocket = new ItemStack((ItemLike)IUItem.rocket.getItem());
                    break;
                }
                case TWO: {
                    rocket = new ItemStack((ItemLike)IUItem.adv_rocket.getItem());
                    break;
                }
                case THREE: {
                    rocket = new ItemStack((ItemLike)IUItem.imp_rocket.getItem());
                    break;
                }
                case FOUR: {
                    rocket = new ItemStack((ItemLike)IUItem.per_rocket.getItem());
                }
            }
            poseStack.pushPose();
            poseStack.translate(0.5, 0.25, 0.5);
            poseStack.scale(2.0f, 3.0f, 2.0f);
            itemRenderer.renderStatic(rocket, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, bufferSource, te.getLevel(), 0);
            poseStack.popPose();
        } else {
            Iterator<DataRocket> iterator = te.rocketList.iterator();
            while (iterator.hasNext()) {
                double offsetZ;
                double offsetX;
                int i;
                DataRocket rocket = iterator.next();
                poseStack.pushPose();
                poseStack.translate(0.5, 0.25, 0.5);
                double y = rocket.getPos();
                double y1 = y - (double)te.getBlockPos().getY();
                poseStack.translate(0.0, y1, 0.0);
                poseStack.scale(2.0f, 3.0f, 2.0f);
                itemRenderer.renderStatic(rocket.getItem(), ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, bufferSource, te.getLevel(), 0);
                poseStack.popPose();
                BlockPos pos = new BlockPos(te.getBlockPos().getX(), (int)y, te.getBlockPos().getZ());
                for (i = 0; i < 10; ++i) {
                    offsetX = (Math.random() - 0.5) * 0.5;
                    offsetZ = (Math.random() - 0.5) * 0.5;
                    te.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5 + offsetX, y, (double)pos.getZ() + 0.5 + offsetZ, 0.0, -0.1, 0.0);
                }
                for (i = 0; i < 5; ++i) {
                    offsetX = (Math.random() - 0.5) * 0.3;
                    offsetZ = (Math.random() - 0.5) * 0.3;
                    te.getLevel().addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5 + offsetX, y, (double)pos.getZ() + 0.5 + offsetZ, 0.0, -0.05, 0.0);
                }
                if (te.getLevel().getGameTime() % 20L == 0L) {
                    te.getLevel().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX() + 0.5, y, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 3; ++i) {
                    offsetX = (Math.random() - 0.5) * 0.5;
                    offsetZ = (Math.random() - 0.5) * 0.5;
                    te.getLevel().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), (double)pos.getX() + 0.5 + offsetX, y, (double)pos.getZ() + 0.5 + offsetZ, 1.0, 0.0, 0.0);
                }
                if (te.getLevel().getGameTime() % 10L == 0L) {
                    te.getLevel().playSound(null, pos, SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.BLOCKS, 1.0f, 1.0f + (float)(Math.random() * 0.2 - 0.1));
                }
                rocket.setPos(rocket.getPos() + 0.25);
                if (!(rocket.getPos() + 0.25 > 255.0)) continue;
                iterator.remove();
            }
        }
    }
}

