/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.sintezator;

import com.denfop.tiles.base.TileSintezator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntitySintezatorRenderer
implements BlockEntityRenderer<TileSintezator> {
    private final BlockRenderDispatcher blockRenderer;
    private final Map<BlockState, BakedModel> modelCache = new HashMap<BlockState, BakedModel>();

    public TileEntitySintezatorRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = Minecraft.getInstance().getBlockRenderer();
    }

    public void render(TileSintezator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack stack = tile.inputslot.get(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            BlockState state = block.defaultBlockState();
            poseStack.pushPose();
            poseStack.translate(0.25 + 0.189 * (double)(i % 3), 0.3125, 0.25 + 0.189 * (double)(i / 3));
            poseStack.scale(0.125f, 0.125f, 0.125f);
            BakedModel model = this.modelCache.computeIfAbsent(state, arg_0 -> ((BlockRenderDispatcher)this.blockRenderer).getBlockModel(arg_0));
            for (Direction direction : Direction.values()) {
                this.renderQuads(poseStack, bufferSource, model.getQuads(state, direction, tile.getLevel().getRandom()), combinedLight, combinedOverlay);
            }
            this.renderQuads(poseStack, bufferSource, model.getQuads(state, null, tile.getLevel().getRandom()), combinedLight, combinedOverlay);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderQuads(PoseStack poseStack, MultiBufferSource bufferSource, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.solid());
        PoseStack.Pose pose = poseStack.last();
        for (BakedQuad quad : quads) {
            buffer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

