/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.squeezer;

import com.denfop.componets.Fluids;
import com.denfop.render.RenderFluidBlock;
import com.denfop.tiles.mechanism.TileEntitySqueezer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class TileEntityRenderSqueezer
implements BlockEntityRenderer<TileEntitySqueezer> {
    private final BlockEntityRendererProvider.Context contex;

    public TileEntityRenderSqueezer(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(TileEntitySqueezer tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        Fluids.InternalFluidTank tank;
        FluidStack fluidStack;
        ItemStack itemStack = tile.inputSlotA.get(0);
        ItemRenderer itemRenderer = this.contex.getItemRenderer();
        if (!itemStack.isEmpty()) {
            poseStack.pushPose();
            if (tile.facing == 4) {
                poseStack.translate(0.48, 0.875, -0.125);
            }
            if (tile.facing == 5) {
                poseStack.translate(0.52, 0.875, 0.89);
            }
            if (tile.facing == 3) {
                poseStack.translate(0.0, 0.875, 0.48);
            }
            if (tile.facing == 2) {
                poseStack.translate(1.0, 0.875, 0.3);
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, combinedOverlay, poseStack, bufferSource, tile.getLevel(), 0);
            poseStack.popPose();
        }
        if (!(fluidStack = (tank = tile.fluidTank1).getFluid()).isEmpty()) {
            float scale = 1.45f * (float)tank.getFluidAmount() * 1.0f / (float)tank.getCapacity();
            poseStack.pushPose();
            if (tile.facing == 4) {
                poseStack.translate(0.19, 0.18, 0.6799999999999999);
            }
            if (tile.facing == 5) {
                poseStack.translate(0.19, 0.18, -0.28);
            }
            if (tile.facing == 2) {
                poseStack.translate(-0.28, 0.18, 0.19);
            }
            if (tile.facing == 3) {
                poseStack.translate(0.6799999999999999, 0.18, 0.19);
            }
            RenderFluidBlock.renderFluid(fluidStack, bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.82f);
            poseStack.popPose();
        }
    }
}

