/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerAntiUpgrade;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiAntiUpgradeBlock;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlotAntiUpgradeBlock;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.Keyboard;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileAntiUpgradeBlock
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final InvSlotAntiUpgradeBlock input = new InvSlotAntiUpgradeBlock(this);
    public int index = 0;
    public int progress = 0;
    public boolean need = false;

    public TileAntiUpgradeBlock(BlockPos pos, BlockState state) {
        super(1000.0, 14, 4, BlockBaseMachine3.antiupgradeblock, pos, state);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.antiupgradeblock;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "5" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need && !this.input.isEmpty() && this.energy.canUseEnergy(5.0)) {
            ++this.progress;
            this.energy.useEnergy(5.0);
            if (this.progress >= 100) {
                List<ItemStack> list = UpgradeSystem.system.getListStack(this.input.get(0));
                if (this.outputSlot.canAdd(list.get(this.index))) {
                    this.outputSlot.add(list.get(this.index));
                }
                UpgradeSystem.system.removeUpdate(this.input.get(0), this.getWorld(), ((ISubEnum)((ItemUpgradeModule)list.get(this.index).getItem()).getElement()).getId());
                this.need = false;
                this.progress = 0;
            }
        }
    }

    public ContainerAntiUpgrade getGuiContainer(Player entityPlayer) {
        return new ContainerAntiUpgrade(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAntiUpgradeBlock((ContainerAntiUpgrade)menu);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getInt("progress");
        this.need = nbttagcompound.getBoolean("need");
        this.index = nbttagcompound.getInt("index");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("progress", this.progress);
        nbttagcompound.putInt("index", this.index);
        nbttagcompound.putBoolean("need", this.need);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        List<ItemStack> list;
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
            return;
        }
        if (this.input.isEmpty()) {
            return;
        }
        if (this.need && i == 0.0) {
            return;
        }
        if (i >= 1.0 && !(list = UpgradeSystem.system.getListStack(this.input.get(0))).get((int)(i - 1.0)).isEmpty()) {
            this.index = (int)(i - 1.0);
            return;
        }
        if (i == 0.0) {
            list = UpgradeSystem.system.getListStack(this.input.get(0));
            boolean need = false;
            if (list.size() < this.index) {
                this.need = false;
            } else {
                ItemStack stack = list.get(this.index);
                if (!stack.isEmpty() && this.outputSlot.canAdd(stack)) {
                    need = true;
                }
                this.need = need;
            }
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

