/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerAutomaticMechanism;
import com.denfop.container.ContainerBase;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiAutomaticMechanism;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.HandlerInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.Upgrade;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityAutomaticMechanism
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    public final InvSlot slotOI;
    public final Map<Direction, HandlerInventory> iItemHandlerMap = new HashMap<Direction, HandlerInventory>();
    public final Map<IItemHandler, Integer> slotHandler = new HashMap<IItemHandler, Integer>();
    private final IItemHandler main_handler;
    public Map<Direction, Upgrade> typeUpgradeMap = new HashMap<Direction, Upgrade>();
    public Map<Direction, List<ItemStack>> extract = new HashMap<Direction, List<ItemStack>>();
    public Map<Direction, List<ItemStack>> pulling = new HashMap<Direction, List<ItemStack>>();
    private int type = 0;
    private boolean put = false;

    public TileEntityAutomaticMechanism(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.automatic_mechanism, pos, state);
        this.slot = new SlotInfo(this, this, 36, false){

            @Override
            public ItemStack set(int index, ItemStack stack) {
                super.set(index, stack);
                ((TileEntityAutomaticMechanism)this.base).updateList();
                return stack;
            }
        };
        this.slotOI = new InvSlot(this, InvSlot.TypeItemSlot.INPUT_OUTPUT, 24){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityAutomaticMechanism.this.put = true;
                return content;
            }
        };
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.put(facing1, Upgrade.NONE);
        }
        this.main_handler = (IItemHandler)this.getCapability(Capabilities.ItemHandler.BLOCK, this.getFacing());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        for (Direction facing1 : Direction.values()) {
            customPacketBuffer.writeInt(this.typeUpgradeMap.get(facing1).ordinal());
        }
        return customPacketBuffer;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.automation_mechanism.info"));
        tooltip.add(Localization.translate("iu.automation_mechanism.info1"));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.replace(facing1, Upgrade.values()[customPacketBuffer.readInt()]);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.typeUpgradeMap.clear();
        for (Direction facing1 : Direction.values()) {
            this.typeUpgradeMap.put(facing1, Upgrade.values()[nbtTagCompound.getInt(facing1.name().toLowerCase())]);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt = super.writeToNBT(nbt);
        for (Direction facing1 : this.typeUpgradeMap.keySet()) {
            nbt.putInt(facing1.name().toLowerCase(), this.typeUpgradeMap.get(facing1).ordinal());
        }
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.updateList();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.level.getGameTime() % 20L == 0L) {
            this.iItemHandlerMap.clear();
            this.slotHandler.clear();
            for (Direction facing : Direction.values()) {
                BlockPos pos = this.getPos().offset(facing.getNormal());
                BlockEntity tile1 = this.getWorld().getBlockEntity(pos);
                IItemHandler handler = ModUtils.getItemHandler(tile1, facing.getOpposite());
                if (!(tile1 instanceof Container)) {
                    if (handler == null) {
                        this.iItemHandlerMap.put(facing, null);
                    } else {
                        this.iItemHandlerMap.put(facing, new HandlerInventory(handler, null));
                    }
                } else {
                    this.iItemHandlerMap.put(facing, new HandlerInventory(handler, (Container)tile1));
                }
                if (handler == null) continue;
                this.slotHandler.put(handler, handler.getSlots());
            }
        }
        if (this.level.getGameTime() % 3L == 0L) {
            for (Map.Entry entry : this.typeUpgradeMap.entrySet()) {
                switch ((Upgrade)((Object)entry.getValue())) {
                    case EXTRACT: {
                        this.tick((Direction)entry.getKey());
                        break;
                    }
                    case PULLING: {
                        this.tickPullIn((Direction)entry.getKey());
                        break;
                    }
                    case EXT_PUL: {
                        this.tick((Direction)entry.getKey());
                        this.tickPullIn((Direction)entry.getKey());
                    }
                }
            }
        }
    }

    private void tickPullIn(Direction facing) {
        block22: {
            List itemStackList = this.pulling.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block22;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                List<InvSlot> inputs = this.getParent().getInputSlots();
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                List<InvSlot> outputs = inventory.getOutputSlots();
                for (InvSlot slot : outputs) {
                    for (InvSlot invSlot : inputs) {
                        ItemStack input;
                        if (invSlot.acceptAllOrIndex()) {
                            for (int j = 0; j < slot.size(); ++j) {
                                ItemStack output = slot.get(j);
                                if (output.isEmpty() || output.getCount() == output.getMaxStackSize()) continue;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    for (ItemStack stack : itemStackList) {
                                        if (!ModUtils.checkItemEquality(stack, output)) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                }
                                if (!invSlot.accepts(output, 0)) continue;
                                for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                    int maxCount;
                                    input = invSlot.get(jj);
                                    if (input.isEmpty()) {
                                        if (!invSlot.add(output)) continue;
                                        slot.set(j, ItemStack.EMPTY);
                                        output = ItemStack.EMPTY;
                                        continue;
                                    }
                                    if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                    input.grow(maxCount);
                                    output.shrink(maxCount);
                                }
                            }
                            continue;
                        }
                        block7: for (int jj = 0; jj < slot.size(); ++jj) {
                            ItemStack output;
                            for (int j = 0; j < invSlot.size() && !(output = slot.get(jj)).isEmpty(); ++j) {
                                int maxCount;
                                boolean find = false;
                                if (!itemStackList.isEmpty()) {
                                    input = itemStackList.iterator();
                                    while (input.hasNext()) {
                                        ItemStack stack = (ItemStack)input.next();
                                        if (!stack.is(output.getItem())) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue block7;
                                }
                                if ((input = invSlot.get(j)).isEmpty()) {
                                    if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                    slot.set(jj, ItemStack.EMPTY);
                                    output = ItemStack.EMPTY;
                                    continue;
                                }
                                if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                input.grow(maxCount);
                                output.shrink(maxCount);
                            }
                        }
                    }
                }
            } else {
                int slots = 0;
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                for (int j = 0; j < slots; ++j) {
                    ItemStack took1;
                    ItemStack took = handler.getHandler().extractItem(j, 64, true);
                    if (took.isEmpty()) continue;
                    boolean find = false;
                    if (!itemStackList.isEmpty()) {
                        for (ItemStack stack : itemStackList) {
                            if (!stack.is(took.getItem())) continue;
                            find = true;
                            break;
                        }
                        if (!find) continue;
                    }
                    if ((took1 = ModUtils.insertItem(this.main_handler, took, true, this.main_handler.getSlots())).isEmpty()) {
                        took = handler.getHandler().extractItem(j, took.getCount(), false);
                        ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                        continue;
                    }
                    if (took1 == took) continue;
                    int count = took1.getCount() - took.getCount();
                    count = Math.abs(count);
                    took = handler.getHandler().extractItem(j, count, false);
                    ModUtils.insertItem(this.main_handler, took, false, this.main_handler.getSlots());
                }
            }
        }
    }

    private void tick(Direction facing) {
        block27: {
            List itemStackList = this.extract.getOrDefault(facing, Collections.emptyList());
            if (facing == null) break block27;
            HandlerInventory handler = this.iItemHandlerMap.get(facing);
            if (handler == null) {
                return;
            }
            int slots = 0;
            if (handler.getInventory() != null && handler.getInventory() instanceof TileEntityInventory) {
                TileEntityInventory inventory = (TileEntityInventory)handler.getInventory();
                InvSlot slot = this.slotOI;
                for (InvSlot invSlot : inventory.getInputSlots()) {
                    if (invSlot.acceptAllOrIndex()) {
                        for (int j = 0; j < slot.size(); ++j) {
                            ItemStack output = slot.get(j);
                            if (output.isEmpty()) continue;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.is(output.getItem())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue;
                            }
                            if (!invSlot.accepts(output, 0)) continue;
                            for (int jj = 0; jj < invSlot.size() && !output.isEmpty(); ++jj) {
                                int maxCount;
                                ItemStack input = invSlot.get(jj);
                                if (input.isEmpty()) {
                                    if (!invSlot.add(output)) continue;
                                    slot.set(j, ItemStack.EMPTY);
                                    output = ItemStack.EMPTY;
                                    continue;
                                }
                                if (!ModUtils.checkItemEquality(input, output) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                                input.grow(maxCount);
                                output.shrink(maxCount);
                            }
                        }
                        continue;
                    }
                    block6: for (int jj = 0; jj < slot.size(); ++jj) {
                        for (int j = 0; j < invSlot.size(); ++j) {
                            int maxCount;
                            ItemStack output = slot.get(jj);
                            ItemStack input = invSlot.get(j);
                            if (output.isEmpty()) continue block6;
                            boolean find = false;
                            if (!itemStackList.isEmpty()) {
                                for (ItemStack stack : itemStackList) {
                                    if (!stack.is(output.getItem())) continue;
                                    find = true;
                                    break;
                                }
                                if (!find) continue block6;
                            }
                            if (input.isEmpty()) {
                                if (!invSlot.accepts(output, j) || !invSlot.add(output)) continue;
                                slot.set(jj, ItemStack.EMPTY);
                                output = ItemStack.EMPTY;
                                continue;
                            }
                            if (!output.is(input.getItem()) || (maxCount = Math.min(input.getMaxStackSize() - input.getCount(), output.getCount())) <= 0) continue;
                            input.grow(maxCount);
                            output.shrink(maxCount);
                        }
                    }
                }
            } else {
                try {
                    slots = this.slotHandler.get(handler.getHandler());
                }
                catch (Exception inventory) {
                    // empty catch block
                }
                if (handler.getInventory() != null) {
                    InvSlot slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack stack;
                        ItemStack took = slot.get(j);
                        if (took.isEmpty()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack2 : itemStackList) {
                                if (!stack2.is(took.getItem())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        if ((stack = this.insertItem1(handler, took, true, slots)).isEmpty()) {
                            slot.set(j, ItemStack.EMPTY);
                            this.insertItem1(handler, took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).getCount() - stack.getCount();
                        slot.get(j).shrink(col);
                        stack.setCount(col);
                        this.insertItem1(handler, stack, false, slots);
                    }
                } else {
                    InvSlot slot = this.slotOI;
                    for (int j = 0; j < slot.size(); ++j) {
                        ItemStack took = slot.get(j);
                        if (took.isEmpty()) continue;
                        boolean find = false;
                        if (!itemStackList.isEmpty()) {
                            for (ItemStack stack : itemStackList) {
                                if (!stack.is(took.getItem())) continue;
                                find = true;
                                break;
                            }
                            if (!find) continue;
                        }
                        took = took.copy();
                        ItemStack stack = ModUtils.insertItem(handler.getHandler(), took, true, slots);
                        if (stack.isEmpty()) {
                            slot.set(j, ItemStack.EMPTY);
                            ModUtils.insertItem(handler.getHandler(), took, false, slots);
                            continue;
                        }
                        if (stack == took) continue;
                        int col = slot.get(j).getCount() - stack.getCount();
                        slot.get(j).shrink(col);
                        stack.setCount(col);
                        ModUtils.insertItem(handler.getHandler(), stack, false, slots);
                    }
                }
            }
        }
    }

    @Nonnull
    public ItemStack insertItem1(HandlerInventory dest, @Nonnull ItemStack stack, boolean simulate, int slot) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < slot; ++i) {
            ItemStack stack2 = this.insertItem2(dest, i, stack, simulate);
            if (stack2.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (stack2 == stack) continue;
            return stack2;
        }
        return stack;
    }

    public boolean canItemStacksStack(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.isEmpty() || !a.is(b.getItem()) || a.getComponents().isEmpty() != b.getComponents().isEmpty()) {
            return false;
        }
        return a.getComponents().isEmpty() || a.getComponents().equals((Object)b.getComponents());
    }

    @Nonnull
    public ItemStack insertItem2(HandlerInventory dest1, int slot, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack stackInSlot;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IItemHandler dest = dest1.getHandler();
        Container inventory = dest1.getInventory();
        try {
            stackInSlot = inventory.getItem(slot);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            stackInSlot = dest.getStackInSlot(slot);
        }
        if (!stackInSlot.isEmpty()) {
            int max = stackInSlot.getMaxStackSize();
            int limit = dest.getSlotLimit(slot);
            if (stackInSlot.getCount() >= Math.min(max, limit)) {
                return stack;
            }
            if (simulate && !inventory.canPlaceItem(slot, stack)) {
                return stack;
            }
            if (!this.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            int m = Math.min(max, limit) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    inventory.setItem(slot, copy);
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                inventory.setItem(slot, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!inventory.canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), dest.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                inventory.setItem(slot, stack.split(m));
            }
            return stack;
        }
        if (!simulate) {
            try {
                inventory.setItem(slot, stack);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                dest.insertItem(slot, stack, false);
            }
        }
        return ItemStack.EMPTY;
    }

    public ContainerAutomaticMechanism getGuiContainer(Player var1) {
        return new ContainerAutomaticMechanism(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAutomaticMechanism((ContainerAutomaticMechanism)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.automatic_mechanism;
    }

    private void updateList() {
        this.extract.clear();
        this.pulling.clear();
        block5: for (Direction facing1 : Direction.values()) {
            Upgrade upgrade = this.typeUpgradeMap.get(facing1);
            if (upgrade == Upgrade.NONE) continue;
            LinkedList<Object> itemStackList = new LinkedList<Object>();
            LinkedList<ItemStack> itemStackList1 = new LinkedList<ItemStack>();
            for (int i = facing1.ordinal() * 6; i < facing1.ordinal() * 6 + 6; ++i) {
                ItemStack stack = this.slot.get(i);
                if (!stack.isEmpty() && i >= facing1.ordinal() * 6 && i < facing1.ordinal() * 6 + 3) {
                    itemStackList.add(stack);
                    continue;
                }
                if (stack.isEmpty()) continue;
                itemStackList1.add(stack);
            }
            switch (upgrade) {
                case EXTRACT: {
                    itemStackList.addAll(itemStackList1);
                    this.extract.put(facing1, itemStackList);
                    continue block5;
                }
                case PULLING: {
                    itemStackList.addAll(itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                    continue block5;
                }
                case EXT_PUL: {
                    this.extract.put(facing1, itemStackList1);
                    this.pulling.put(facing1, itemStackList);
                }
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        Upgrade typeUpgrade = this.typeUpgradeMap.get(Direction.values()[(int)var2]);
        Upgrade newTypeUpgrade = Upgrade.values()[(typeUpgrade.ordinal() + 1) % 4];
        this.typeUpgradeMap.replace(Direction.values()[(int)var2], newTypeUpgrade);
        this.updateList();
    }
}

