/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.container.ContainerAutoFuse;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiAutoFuse;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityAutoFuse
extends TileEntityInventory {
    public final InvSlot slotBomb = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.getItem() == IUItem.nuclear_bomb.getItem();
        }
    };
    public final ComponentBaseEnergy rad_energy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 100000.0));
    private final Redstone redstone = this.addComponent(new Redstone(this));
    public boolean fuse = false;
    public int timer = 60;
    private boolean boom = false;

    public TileEntityAutoFuse(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.autofuse, pos, state);
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                TileEntityAutoFuse.this.fuse = !TileEntityAutoFuse.this.fuse;
                new PacketUpdateFieldTile(TileEntityAutoFuse.this.getParent(), "fuse", TileEntityAutoFuse.this.fuse);
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.autofuse.info"));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.autofuse;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.fuse = customPacketBuffer.readBoolean();
        this.timer = customPacketBuffer.readInt();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.fuse);
        customPacketBuffer.writeInt(this.timer);
        return customPacketBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAutoFuse((ContainerAutoFuse)menu);
    }

    public ContainerAutoFuse getGuiContainer(Player var1) {
        return new ContainerAutoFuse(this, var1);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("timer")) {
            is.readUnsignedByte();
            this.timer = is.readInt();
            if (this.timer == 0) {
                this.boom = true;
            }
        }
        if (name.equals("fuse")) {
            is.readUnsignedByte();
            this.fuse = is.readBoolean();
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putBoolean("fuse", this.fuse);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.fuse = nbtTagCompound.getBoolean("fuse");
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.fuse && !this.slotBomb.isEmpty() && this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                if (this.boom) {
                    this.boom = false;
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                this.timer = 60;
            } else {
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(this.fuse);
        if (this.fuse && !this.slotBomb.isEmpty() && this.timer >= 0) {
            if (this.timer != 0) {
                --this.timer;
            }
            if (this.timer % 10 == 0) {
                new PacketUpdateFieldTile(this, "timer", this.timer);
            }
            if (this.timer == 0) {
                this.rad_energy.addEnergy(300.0);
                this.slotBomb.get(0).shrink(1);
                this.timer = 60;
            }
        }
    }
}

