/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGenomeExtractor;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGenomeExtractor;
import com.denfop.invslot.InvSlot;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityGenomeExtractor
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlotOutput slot = new InvSlotOutput(this, 1);
    public final ComponentBaseEnergy energy;
    public final InvSlot input = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.getItem() instanceof ICropItem || stack.getItem() instanceof ItemJarBees;
        }

        @Override
        public ItemStack set(int index, ItemStack content) {
            super.set(index, content);
            if (content.isEmpty()) {
                TileEntityGenomeExtractor.this.genBee = null;
                TileEntityGenomeExtractor.this.genCrop = null;
            } else if (content.getItem() instanceof ICropItem) {
                TileEntityGenomeExtractor.this.genCrop = new com.denfop.api.agriculture.genetics.Genome(content);
                TileEntityGenomeExtractor.this.genBee = null;
            } else {
                TileEntityGenomeExtractor.this.genBee = new Genome(content);
                TileEntityGenomeExtractor.this.genCrop = null;
            }
            return content;
        }
    };
    public com.denfop.api.agriculture.genetics.Genome genCrop;
    public Genome genBee;
    int meta = -1;
    private boolean work;

    public TileEntityGenomeExtractor(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.genome_extractor, pos, state);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.QUANTUM, this, 1000.0));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        ItemStack stack;
        super.readContainerPacket(customPacketBuffer);
        boolean hasGenCrop = customPacketBuffer.readBoolean();
        boolean hasGenBee = customPacketBuffer.readBoolean();
        if (hasGenCrop) {
            stack = ItemStack.EMPTY;
            try {
                stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.genCrop = new com.denfop.api.agriculture.genetics.Genome(stack);
        } else {
            this.genCrop = null;
        }
        if (hasGenBee) {
            stack = ItemStack.EMPTY;
            try {
                stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.genBee = new Genome(stack);
        } else {
            this.genBee = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.genCrop != null);
        customPacketBuffer.writeBoolean(this.genBee != null);
        if (this.genCrop != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.genCrop.getStack());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.genBee != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.genBee.getStack());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.genome_extractor;
    }

    public ContainerGenomeExtractor getGuiContainer(Player var1) {
        return new ContainerGenomeExtractor(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGenomeExtractor((ContainerGenomeExtractor)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && !this.input.get(0).isEmpty() && this.slot.isEmpty() && this.meta != -1) {
            if (this.energy.getEnergy() >= 50.0) {
                this.energy.useEnergy(50.0);
                this.work = false;
                if (this.genCrop != null) {
                    this.genCrop.removeGenome(com.denfop.api.agriculture.genetics.GeneticTraits.values()[this.meta], this.input.get(0));
                    this.slot.add(new ItemStack((ItemLike)IUItem.genome_crop.getStack(this.meta), 1));
                } else if (this.genBee != null) {
                    this.genBee.removeGenome(GeneticTraits.values()[this.meta], this.input.get(0));
                    this.slot.add(new ItemStack((ItemLike)IUItem.genome_bee.getStack(this.meta), 1));
                }
            }
            this.meta = -1;
        } else {
            this.work = false;
            if (this.input.get(0).isEmpty()) {
                this.genCrop = null;
                this.genBee = null;
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == -1.0) {
            this.work = true;
        } else {
            this.meta = (int)var2;
        }
    }
}

