/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalWireInsulator;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityPrimalWireInsulator
extends TileEntityInventory
implements IUpdateTick,
IAudioFixer {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.25, 1.0));
    public final InvSlotRecipes inputSlotA;
    public final InvSlotOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.WIRE_INSULATOR);

    public TileEntityPrimalWireInsulator(BlockPos pos, BlockState state) {
        super(BlockPrimalWireInsulator.primal_wire_insulator, pos, state);
        this.inputSlotA = new InvSlotRecipes(this, "wire_insulator", this){

            @Override
            public int getStackSizeLimit() {
                if (TileEntityPrimalWireInsulator.this.output == null) {
                    return 1;
                }
                return TileEntityPrimalWireInsulator.this.output.getRecipe().input.getInputs().get(0).getAmount();
            }
        };
        this.outputSlot = new InvSlotOutput(this, this, 1){

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            return null;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 4; ++i) {
            tooltip.add(Localization.translate("wire_insulator.info" + i));
        }
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        ItemStack stack = drop.get(0);
        return drop;
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blockwireinsulator.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockPrimalWireInsulator.primal_wire_insulator;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            // empty if block
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.WIRE_INSULATOR);
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((InvSlot)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((InvSlot)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.EMPTY);
            this.inputSlotA.set(1, ItemStack.EMPTY);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            this.outputSlot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.getWorld().isClientSide) {
            if (stack.getItem() == IUItem.cutter.getItem() && this.output != null && this.outputSlot.isEmpty() && this.inputSlotA.continue_process(this.output)) {
                this.getCooldownTracker().setTick(10);
                this.progress += (short)(20 + (short)(this.data.getOrDefault(player.getUUID(), 0.0) / 3.3));
                if (!this.getWorld().isClientSide) {
                    this.initiate(0);
                }
                if (this.progress >= 100) {
                    this.progress = 0;
                    this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                    if (!this.getWorld().isClientSide) {
                        PrimitiveHandler.addExperience(EnumPrimitive.WIRE_INSULATOR, 0.5, player.getUUID());
                    }
                    this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                    this.inputSlotA.consume(1, this.output.getRecipe().input.getInputs().get(1).getAmount());
                    this.output = null;
                    player.setItemInHand(hand, stack.getItem().getCraftingRemainingItem(stack));
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot3", this.inputSlotA);
                        new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                    }
                }
                return this.getWorld().isClientSide;
            }
            if (!stack.isEmpty() && this.outputSlot.isEmpty()) {
                if (this.inputSlotA.get(0).isEmpty() && this.inputSlotA.accepts(stack, 0)) {
                    ItemStack stack1 = stack.copy();
                    stack1.setCount(1);
                    this.inputSlotA.set(0, stack1);
                    stack.shrink(1);
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.get(0).isEmpty() && this.inputSlotA.get(0).is(stack.getItem())) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(0).getCount();
                    minCount = Math.min(stack.getCount(), minCount);
                    this.inputSlotA.get(0).grow(minCount);
                    stack.grow(-minCount);
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (this.inputSlotA.get(1).isEmpty() && this.inputSlotA.accepts(stack, 1)) {
                    ItemStack stack1 = stack.copy();
                    stack1.setCount(1);
                    this.inputSlotA.set(1, stack1);
                    stack.shrink(1);
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.get(1).isEmpty() && this.inputSlotA.get(1).is(stack.getItem())) {
                    int minCount = this.inputSlotA.getStackSizeLimit() - this.inputSlotA.get(1).getCount();
                    minCount = Math.min(stack.getCount(), minCount);
                    this.inputSlotA.get(1).grow(minCount);
                    stack.grow(-minCount);
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    }
                    this.changeState();
                    return true;
                }
            } else {
                if (!this.outputSlot.isEmpty()) {
                    if (!this.level.isClientSide) {
                        ModUtils.dropAsEntity(this.level, this.pos, this.outputSlot.get(0));
                    }
                    this.outputSlot.set(0, ItemStack.EMPTY);
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot2", false);
                    }
                    this.changeState();
                    return true;
                }
                if (!this.inputSlotA.isEmpty()) {
                    if (!this.level.isClientSide) {
                        ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(0));
                        ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(1));
                    }
                    this.inputSlotA.set(0, ItemStack.EMPTY);
                    this.inputSlotA.set(1, ItemStack.EMPTY);
                    this.output = null;
                    if (!this.level.isClientSide) {
                        new PacketUpdateFieldTile(this, "slot3", false);
                    }
                    this.changeState();
                    return true;
                }
            }
        }
        return this.level.isClientSide;
    }

    private void changeState() {
        ItemStack input = this.inputSlotA.get(0);
        ItemStack input1 = this.inputSlotA.get(1);
        if (this.outputSlot.isEmpty()) {
            if (!input.isEmpty()) {
                if (input1.isEmpty()) {
                    switch (IUItem.cable.getMetaFromItemStack(input)) {
                        case 11: {
                            this.setActive("copper");
                            break;
                        }
                        case 14: {
                            this.setActive("gold");
                            break;
                        }
                        case 16: {
                            this.setActive("iron");
                            break;
                        }
                        case 18: {
                            this.setActive("tin");
                        }
                    }
                } else {
                    switch (IUItem.cable.getMetaFromItemStack(input)) {
                        case 11: {
                            this.setActive("copper_final");
                            break;
                        }
                        case 14: {
                            this.setActive("gold_final");
                            break;
                        }
                        case 16: {
                            this.setActive("iron_final");
                            break;
                        }
                        case 18: {
                            this.setActive("tin_final");
                        }
                    }
                }
            } else {
                this.setActive("");
            }
        } else {
            switch (IUItem.cable.getMetaFromItemStack(this.outputSlot.get(0))) {
                case 12: {
                    this.setActive("copper_final");
                    break;
                }
                case 15: {
                    this.setActive("gold_final");
                    break;
                }
                case 17: {
                    this.setActive("iron_final");
                    break;
                }
                case 19: {
                    this.setActive("tin_final");
                }
            }
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

