/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.InfoSends;
import com.denfop.api.space.colonies.Sends;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.EnumOperation;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.event.ResearchTableLoadEvent;
import com.denfop.api.space.research.event.ResearchTableReLoadEvent;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerResearchTableSpace;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiResearchTableSpace;
import com.denfop.invslot.InvSlot;
import com.denfop.items.space.ItemResearchLens;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFakeBody;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.world.WorldBaseGen;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TileEntityResearchTableSpace
extends TileEntityInventory
implements IResearchTable {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 2.0, 2.0, 1.5));
    private static final List<AABB> aabbs_east = Collections.singletonList(new AABB(0.0, 0.0, -1.0, 1.0, 2.0, 1.0));
    private static final List<AABB> aabbs_south = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 2.0, 2.0, 1.0));
    private static final List<AABB> aabbs_west = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 2.0, 2.0));
    private static final List<AABB> aabbs_north = Collections.singletonList(new AABB(-1.0, 0.0, 0.0, 1.0, 2.0, 1.0));
    public final InvSlot slotLens;
    public Map<IBody, SpaceOperation> map;
    public List<SpaceOperation> fakeBodySpaceOperationMap;
    public EnumLevels level = EnumLevels.NONE;
    public int timer;
    public Map<IBody, Data> dataMap = new HashMap<IBody, Data>();
    public Map<IBody, SpaceOperation> operationMap;
    public IBody body;
    public IFakeBody fakeBody;
    public IColony colony;
    boolean added = false;
    private UUID player = new UUID(WorldBaseGen.random.nextLong(), WorldBaseGen.random.nextLong());
    private InfoSends sends;

    public TileEntityResearchTableSpace(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.research_table_space, pos, state);
        this.map = new HashMap<IBody, SpaceOperation>();
        this.player = new UUID(WorldBaseGen.random.nextLong(), WorldBaseGen.random.nextLong());
        this.fakeBodySpaceOperationMap = new LinkedList<SpaceOperation>();
        this.slotLens = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof ItemResearchLens;
            }

            @Override
            public void update() {
                super.update();
                TileEntityResearchTableSpace.this.level = this.get(0).isEmpty() ? EnumLevels.NONE : EnumLevels.values()[((ISubEnum)((ItemResearchLens)this.get(0).getItem()).getElement()).getId()];
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                this.update();
                return content;
            }
        };
    }

    public InfoSends getSends() {
        return this.sends;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.research_table_space;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.added) {
            NeoForge.EVENT_BUS.post((Event)new ResearchTableLoadEvent(this.getWorld(), this));
            this.added = true;
        }
        if (!this.getWorld().isClientSide) {
            this.getSpaceBody();
            this.dataMap.clear();
            this.dataMap = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(this.player);
            for (IBody body : SpaceNet.instance.getBodyMap().values()) {
                if (this.dataMap.containsKey(body)) continue;
                this.dataMap.put(body, new Data(this.player, body));
            }
        }
        this.slotLens.update();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            NeoForge.EVENT_BUS.post((Event)new ResearchTableLoadEvent(this.getWorld(), this));
            this.added = false;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.dataMap.clear();
        try {
            CompoundTag nbt = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            ListTag tagList = nbt.getList("list", 10);
            ListIterator it = tagList.listIterator();
            while (it.hasNext()) {
                Tag nbtbase = (Tag)it.next();
                CompoundTag tagCompound = (CompoundTag)nbtbase;
                Data data = new Data(tagCompound);
                this.dataMap.put(data.getBody(), data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean hasColony = customPacketBuffer.readBoolean();
        if (hasColony) {
            this.colony = new Colony(customPacketBuffer);
            this.sends = new InfoSends(customPacketBuffer);
        } else {
            this.colony = null;
            this.sends = null;
        }
        int sizeSpaceBodyInformation = customPacketBuffer.readInt();
        Map<IBody, SpaceOperation> information = this.getSpaceBody();
        information.clear();
        for (int i = 0; i < sizeSpaceBodyInformation; ++i) {
            IBody body1 = SpaceNet.instance.getBodyFromName(customPacketBuffer.readString());
            boolean auto = customPacketBuffer.readBoolean();
            EnumOperation operation = EnumOperation.getID(customPacketBuffer.readInt());
            information.put(body1, new SpaceOperation(body1, operation, auto));
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        ListTag tagList = new ListTag();
        for (Map.Entry<IBody, Data> entry : this.dataMap.entrySet()) {
            CompoundTag nbt = entry.getValue().writeNBT();
            tagList.add((Object)nbt);
        }
        CompoundTag nbtTagCompound = new CompoundTag();
        nbtTagCompound.put("list", (Tag)tagList);
        try {
            EncoderHandler.encode(customPacketBuffer, nbtTagCompound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        customPacketBuffer.writeBoolean(this.colony != null);
        if (this.colony != null) {
            customPacketBuffer.writeBytes((ByteBuf)this.colony.writePacket(customPacketBuffer.registryAccess()));
            List sends = SpaceNet.instance.getColonieNet().getSendsFromUUID(this.player).stream().filter(sends1 -> sends1.getBody() == this.colony.getBody()).collect(Collectors.toList());
            InfoSends infoSends = new InfoSends();
            for (Sends send : sends) {
                infoSends.addTimer(send.getTimerToPlanet());
            }
            customPacketBuffer.writeBytes((ByteBuf)infoSends.writeBuffer(customPacketBuffer.registryAccess()));
        }
        customPacketBuffer.writeInt(this.getSpaceBody().keySet().size());
        for (Map.Entry<IBody, SpaceOperation> entry : this.getSpaceBody().entrySet()) {
            customPacketBuffer.writeString(entry.getKey().getName());
            customPacketBuffer.writeBoolean(entry.getValue().getAuto());
            customPacketBuffer.writeInt(entry.getValue().getOperation().ordinal());
        }
        return customPacketBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiResearchTableSpace((ContainerResearchTableSpace)menu);
    }

    public ContainerResearchTableSpace getGuiContainer(Player var1) {
        return new ContainerResearchTableSpace(this, var1);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 80L == 0L) {
            NeoForge.EVENT_BUS.post((Event)new ResearchTableReLoadEvent(this.getWorld(), this));
        }
        if (this.timer > 0) {
            --this.timer;
        }
        if (this.timer == 0) {
            if (this.body != null || this.fakeBody != null) {
                new PacketUpdateFakeBody(this, null);
            }
            this.body = null;
            this.fakeBody = null;
        }
        if (this.getWorld().getGameTime() % 20L == 0L) {
            boolean find = false;
            if (this.body != null) {
                List<Object> list;
                if (this.colony != null) {
                    if (!this.colony.matched(this.body)) {
                        list = SpaceNet.instance.getColonieNet().getMap().get(this.player);
                        if (list == null || list.isEmpty()) {
                            this.colony = null;
                        } else if ((list = list.stream().filter(colony -> colony.matched(this.body)).collect(Collectors.toList())).isEmpty()) {
                            this.colony = null;
                            this.sends = null;
                        } else {
                            this.colony = (IColony)list.get(0);
                        }
                    } else {
                        List sends = SpaceNet.instance.getColonieNet().getSendsFromUUID(this.player).stream().filter(sends1 -> sends1.getBody() == this.colony.getBody()).collect(Collectors.toList());
                        this.sends = new InfoSends();
                        for (Sends send : sends) {
                            this.sends.addTimer(send.getTimerToPlanet());
                        }
                    }
                } else {
                    list = SpaceNet.instance.getColonieNet().getMap().get(this.player);
                    if (list != null && !list.isEmpty() && !(list = list.stream().filter(colony -> colony.matched(this.body)).collect(Collectors.toList())).isEmpty()) {
                        this.colony = (IColony)list.get(0);
                    }
                }
                list = SpaceNet.instance.getFakeSpaceSystem().getBodyMap().computeIfAbsent(this.player, k -> new LinkedList());
                for (IFakeBody fakeBody : list) {
                    if (!fakeBody.matched(this.body)) continue;
                    this.fakeBody = fakeBody;
                    new PacketUpdateFakeBody(this, this.fakeBody);
                    find = true;
                    break;
                }
                if (!find) {
                    this.fakeBody = null;
                    new PacketUpdateFakeBody(this, null);
                }
            } else {
                this.colony = null;
            }
        }
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            this.player = placer.getUUID();
        }
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        switch (this.getFacing()) {
            case EAST: {
                return aabbs_east;
            }
            case SOUTH: {
                return aabbs_south;
            }
            case WEST: {
                return aabbs_west;
            }
            case NORTH: {
                return aabbs_north;
            }
        }
        return aabbs;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.player = nbtTagCompound.getUUID("player");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putUUID("player", this.player);
        return nbtTagCompound;
    }

    @Override
    public Map<IBody, SpaceOperation> getSpaceBody() {
        if (this.operationMap == null) {
            this.operationMap = SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(this.player);
        }
        return this.operationMap;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public EnumLevels getLevelTable() {
        return this.level;
    }

    @Override
    public void setLevel(EnumLevels level) {
        this.level = level;
    }
}

