/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWirelessControllerReactors;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.ReactorData;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWirelessControllerReactors;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.Keyboard;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TileEntityWirelessControllerReactors
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final InvSlot invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<TileMultiBlockBase> tileMultiBlockBaseList = new LinkedList<TileMultiBlockBase>();

    public TileEntityWirelessControllerReactors(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.wireless_controller_reactors, pos, state);
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 12){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityWirelessControllerReactors.this.updateList();
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.getItem() instanceof ItemReactorData)) {
                    return false;
                }
                return stack.has(DataComponentsInit.REACTOR_DATA);
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerWirelessControllerReactors getGuiContainer(Player var1) {
        return new ContainerWirelessControllerReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWirelessControllerReactors((ContainerWirelessControllerReactors)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_controller_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.tileMultiBlockBaseList.clear();
        this.itemStacks.clear();
        for (int i = 0; i < 12; ++i) {
            if (this.invslot.get(i).isEmpty()) {
                this.tileMultiBlockBaseList.add(null);
                this.itemStacks.add(ItemStack.EMPTY);
                continue;
            }
            @Nullable ReactorData reactorData = (ReactorData)this.invslot.get(i).get(DataComponentsInit.REACTOR_DATA);
            BlockPos pos = reactorData.pos();
            BlockEntity tileEntity = this.getWorld().getBlockEntity(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.tileMultiBlockBaseList.clear();
        for (int i = 0; i < 12; ++i) {
            if (this.invslot.get(i).isEmpty()) {
                this.tileMultiBlockBaseList.add(null);
                this.itemStacks.add(ItemStack.EMPTY);
                continue;
            }
            @Nullable ReactorData reactorData = (ReactorData)this.invslot.get(i).get(DataComponentsInit.REACTOR_DATA);
            BlockPos pos = reactorData.pos();
            BlockEntity tileEntity = this.getWorld().getBlockEntity(pos);
            if (tileEntity instanceof TileMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((TileMultiBlockBase)tileEntity);
                this.itemStacks.add(((TileMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        TileMultiBlockBase tileMultiBlockBase;
        if (!this.itemStacks.get((int)var2).isEmpty() && (tileMultiBlockBase = this.tileMultiBlockBaseList.get((int)var2)) != null && tileMultiBlockBase.isFull() && !tileMultiBlockBase.isRemoved()) {
            tileMultiBlockBase.onActivated(var1, var1.getUsedItemHand(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
        }
    }
}

